///////////////////////////////////////////////////////////
//  clCMADRBaseTypes.h
//  Implementation of the Class clCMADRBaseType_*
//  Created on:      27-Feb-2015 18:59:55
//  Implementation of ADR base types
///////////////////////////////////////////////////////////
#ifndef _clCMADRBaseTypes_h
#define _clCMADRBaseTypes_h

#include "datatypes/tVector.h"
#include "datatypes/tString.h"
#include "clCMEnumTypes.h"

class clCMADRBaseType_PSDDataFrame
{
public:
	clCMADRBaseType_PSDDataFrame() : ProgramNumber(0),
	FieldBitMask(0),
	Subfield(0),
	ReservedByte(0),
	Field_SubfieldLength(0) { }
	virtual ~clCMADRBaseType_PSDDataFrame() { }

	unsigned char ProgramNumber;                                 // 0..0x07
	unsigned char FieldBitMask;                                  // boolean data type
	unsigned char Subfield;                                      // boolean data type
	unsigned char ReservedByte;                                  // 0..0xff
	clCMEnum_PDSFrameSubFieldDataType Field_SubfieldDataType;    // field or subfield data type
	unsigned char Field_SubfieldLength;                          // field or subfield length
	tunerVector<unsigned char> Field_SubfieldData;               // field or subfield data

};

class clCMADRBaseType_PSDDataFrameBytes
{
public:
	clCMADRBaseType_PSDDataFrameBytes() : ReservedByte(0) { }
	virtual ~clCMADRBaseType_PSDDataFrameBytes() { }

	unsigned char ReservedByte;
    tunerVector<clCMADRBaseType_PSDDataFrame> frames;

};

class clCMADRBaseType_TuningActionConfigurationData
{

public:
	clCMADRBaseType_TuningActionConfigurationData() : NumberOfSeekPeriods(1),
	Scantime(5),
	AfBestDelayTime(0),
	PtyFilter(0xffffffff),
	TuningSwitches(0),
	AutoSeekStepDelay(0),
	ManualStepDelay(0),
	WrongPiAcceptDelay(0xff),
	NONRDSdetectionTimer(0),
	TPSeekAfterRDSlostTimer(0),
	AMStationInListRemoveTimer(0),
	ScrollingPSdetectionTimer(0) { }
	virtual ~clCMADRBaseType_TuningActionConfigurationData() { }
	/**
	 * Define the number of seek periods in case that no station is found. Default
	 * value: 1
	 */
	unsigned char NumberOfSeekPeriods;
	/**
	 * Define the play period of the last tuned scan station. Default value: 5 seconds
	 */
	unsigned char Scantime;
	/**
	 * After a seek, an AFBest jump can be delayed by a given number of seconds.
	 * Default value: 0 seconds
	 */
	unsigned char AfBestDelayTime;
	/**
	 * Enumeration 0..2
	 * Choose one of the provided TPSeek strategies.
	 * Default value: 0
	 */
	clCMEnum_TPSeekStrategy TPSeekStrategy;
	/**
	 * Boolean (4 bytes) Choose the PTY codes that are to be considered for filtering.
	 * Default value: 0xffffffff
	 * Bit  Description
	 * 0    NO PTY
	 * 1    News
	 * 2    Current Affairs
	 * 3    Information
	 * 4    Sport
	 * 5    Education
	 * 6    Drama
	 * 7    Culture
	 * 8    Science
	 * 9    Varied
	 * 10  Pop Music
	 * 11  Rock Music
	 * 12  Easy Listening
	 * 13  Light Classical
	 * 14  Serious Classical
	 * 15  Other Music
	 * 16  Weather
	 * 17  Finance
	 * 18  For Children
	 * 19  Social Affairs
	 * 20  Religion
	 * 21  Phone In
	 * 22  Travel
	 * 23  Leisure
	 * 24  Jazz Music
	 * 25  Country Music
	 * 26  National Music
	 * 27  Oldies Music
	 * 28  Folk Music
	 * 29  Documentary
	 * 30  Alarm Test
	 * 31  Alarm
	 */
	unsigned int PtyFilter;
	/**
	 * Boolean (1 byte)
	 * Configure switches that affect the tuning behaviour in certain cases. Default
	 * value: 0
	 */
	unsigned char TuningSwitches;
	/**
	 * Unsigned word 0..0xffff
	 * Default value: 0 milliseconds.
	 */
	unsigned short AutoSeekStepDelay;
	/**
	 * Unsigned word 0..0xffff
	 * Default value: 0 milliseconds.
	 */
	unsigned short ManualStepDelay;
	/**
	 * Unsigned byte 0..0xff
	 * Default value: 0xff
	 */
	unsigned char WrongPiAcceptDelay;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char NONRDSdetectionTimer;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char TPSeekAfterRDSlostTimer;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char AMStationInListRemoveTimer;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char ScrollingPSdetectionTimer;
	/**
	 * returns size of Data
	 */
	short getSize(unsigned char x, unsigned char y);
	short getNumberOfSeekPeriodsSize(unsigned char x, unsigned char y);
	short getScantimeSize(unsigned char x, unsigned char y);
	short getAfBestDelayTimeSize(unsigned char x, unsigned char y);
	short getTPSeekStrategySize(unsigned char x, unsigned char y);
	short getPtyFilterSize(unsigned char x, unsigned char y);
	short getTuningSwitchesSize(unsigned char x, unsigned char y);
	short getAutoSeekStepDelaySize(unsigned char x, unsigned char y);
	short getManualStepDelaySize(unsigned char x, unsigned char y);
	short getWrongPiAcceptDelaySize(unsigned char x, unsigned char y);
	short getNONRDSdetectionTimerSize(unsigned char x, unsigned char y);
	short getTPSeekAfterRDSlostTimerSize(unsigned char x, unsigned char y);
	short getAMStationInListRemoveTimerSize(unsigned char x, unsigned char y);
	short getScrollingPSdetectionTimerSize(unsigned char x, unsigned char y);
};

class clCMATPresetList_Data
{
public:
	clCMATPresetList_Data() :
		NumberOfBytesInElement(0),
		PresetSelection(0),
		Frequency(0),
		PI(0),
		TpTmcInfo(0),
		PTY(0),
		LevelCompensation(0),
		HDStationID_DRMServiceID(0),
		StationNameLength(0),
		HDTextEncoding(0),
		HDStationGenre_DRMPty(0),
		HDProgramNumber_DRMServiceShortId(0){ }

	void vSetSenderName(tunerString oString)
	{
		Sendername = oString;
	}
	void vSetHDCallSign_DRMServiceLabel(tunerString oString)
	{
		HDCallSign_DRMServiceLabel = oString;
	}

	unsigned char NumberOfBytesInElement;
	unsigned char PresetSelection;
	unsigned int Frequency;
	tunerString Sendername;
	unsigned short PI;
	clCMEnum_StationNameInfo StationNameInfo;
	unsigned char TpTmcInfo;
	unsigned char PTY;
	signed char LevelCompensation;
	clCMEnum_DigitalModulation DigitalModulation;
	unsigned int HDStationID_DRMServiceID;
	unsigned char StationNameLength;
	tunerString HDCallSign_DRMServiceLabel;
	unsigned char HDTextEncoding;
	unsigned char HDStationGenre_DRMPty;
	unsigned char HDProgramNumber_DRMServiceShortId;
};
class clCMPresetListContentUpdate_Data
{
public:
	clCMPresetListContentUpdate_Data() :
		FktIdOfList(0),
		ElementID(0),
		ModulationType(),
		Band(0),
		Frequency(0),
		SID(0),
		ProgramService(0),
		NumberOfCharactersInStationName(0),
		ServiceNameEncoding(0),
		ServiceName(""){ }
	unsigned short FktIdOfList;
	unsigned char ElementID;
	clCMEnum_ModulationType ModulationType;
	unsigned char Band;
	unsigned int Frequency;
	unsigned int SID;
	unsigned char ProgramService;
	size_t NumberOfCharactersInStationName;
	unsigned char ServiceNameEncoding;
	tunerString ServiceName;
};

class clCMADRBaseType_Pos
{
public:
	clCMADRBaseType_Pos() : x(0), y(0) { }

	unsigned char x;
	unsigned char y;
};

class clCMADRBaseType_TMCStationsDataStream
{
public:
	clCMADRBaseType_TMCStationsDataStream() :
		Frequency(0),
		PI(0),
		Quality(0),
		RdbIdPrio(0),
		CC(0),
		LTN(0),
		SID(0) { }
	virtual ~clCMADRBaseType_TMCStationsDataStream() { }
	/**
	 * Unsigned long word 87500...108000
	 */
	unsigned int Frequency;
	/**
	 * Unsigned word 0..0xffff
	 */
	unsigned short PI;
	/**
	 * String - 8 bytes size
	 */
	tunerString StationName;
	/**
	 * Unsigned byte 0..31
	 */
	unsigned char Quality;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char RdbIdPrio;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char CC;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char LTN;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char SID;
	/**
	 * Enumeration 0..1
	 * 0 Not Encrypted
	 * 1 Encrypted
	 */
	clCMEnum_EncryptionFlag EncryptionFlag;
};

class clCMADRBaseType_TMCStationsData
{
public:
	clCMADRBaseType_TMCStationsData() : NumberOfStationsInList(0){

	}
	virtual ~clCMADRBaseType_TMCStationsData() { }
	/**
	 * Unsigned byte 0..255
	 */
	unsigned char NumberOfStationsInList;
	/**
	 * stream
	 */
	tunerVector<clCMADRBaseType_TMCStationsDataStream> DataStream;
};

class clCMADRBaseType_FixedLengthString
{
public:
	tunerString szValue;
	clCMADRBaseType_FixedLengthString() { }
	~clCMADRBaseType_FixedLengthString() { }

	void setFixedString(tunerString newszValue)
	{
		szValue = newszValue;
	}

	tunerString getFixedString()
	{
		return szValue;
	}

	void Serialize(tunerVector<unsigned char> &payload, unsigned char maxSize, bool bIsFixedLength)
	{
		if(szValue.size() < (int)maxSize)
		{
			if(szValue.size() == 0)
			{
				payload.push_back((unsigned char)0);
				return;
			}
			(bIsFixedLength == true)?payload.push_back(maxSize):payload.push_back((unsigned char)szValue.size());
			int count = 0;
			for(; count < (int)szValue.size(); count++)
			{
				payload.push_back(szValue[count]);
			}
			if(bIsFixedLength == true)
			{
				for(; count < (int)maxSize; count++)
				{
					payload.push_back((unsigned char)0);
				}
			}
		}
		else
		{
			payload.push_back(maxSize);
			for(int index=0; index < (int)maxSize; index++)
			{
				payload.push_back(szValue[index]);
			}
		}
	}

	void Construct(tunerVector<unsigned char> bitStream, unsigned short& position)
	{
		szValue.clear();
		unsigned short size = bitStream[position++];
		szValue.assign ( (const char *)(&bitStream[position]), size );
		position = (unsigned short)(position + size);
	}
};

class clCMADRBaseType_StationsListData
{

public:
	clCMADRBaseType_StationsListData() :
		NumberOfBytesInElement(0),
		Frequency(0),
		RDS_HD_DRM_Pty(0),
		PI_HDStationId_DRMServiceId(0),
		TpInfo(0),
		ReceptionQuality(0),
		PresetListForAcmp(0),
		PresetAcmp(0),
		LevelCompensation(0),
		HDTextEncoding(0),
		HDNumberOfAudioPrograms(0),
		Drmlanguage(0){ }
	virtual ~clCMADRBaseType_StationsListData() { }
	/**
		 * Actual number of bytes for all parameters in list element
	*/
	unsigned char NumberOfBytesInElement;
	/**
	 * Enumeration 0..1
	 * 0 Not active
	 * 1 active
	 */
	clCMEnum_Selected Selected;
	/**
	 * Enumeration 0..2
	 * 0 Analog (FM/AM)
	 * 1 HD
	 * 2 DRM
	 */
	clCMEnum_ModulationType ModulationType;
	/**
	 * Unsigned long 150..108000 kHz
	 */
	unsigned int Frequency;
	/**
	 * Sendername / HDCallSign / DRMServiceLabel. Byte array.
	 * 1+N bytes . First byte indicates the number N of following bytes containing the
	 * character data. RDS PS: N = 8 bytes (fixed). HD Radio: N = 16 bytes (fixed).
	 * DRM: N = 1..64 bytes.
	 */
	clCMADRBaseType_FixedLengthString Sendername_HDCallSign_DRMServiceLabel;
	/**
	 * Enumeration 0..5
	 * 0 NON-RDS Station
	 * 1 Station name is first received PS (freezed after last tuning)
	 * 2 Station name is last received PS (may be scrolling PS)
	 * 3 not supported
	 * 4 Name assigned by customer
	 * 5 not supported
	 */
	clCMEnum_SendernameInfo SendernameInfo;
	/**
	 * RDS(RDBS) PTY / HD PTY / DRMPty
	 * Unsigned byte 0..99
	 */
	unsigned char RDS_HD_DRM_Pty;
	/**
	 * Sendername / HDCallSign / DRMServiceLabel
	 * Unsigned long word 0..0xffffffff
	 */
	unsigned int PI_HDStationId_DRMServiceId;
	/**
	 * Boolean(1 byte)
	 */
	unsigned char TpInfo;
	/**
	 * Unsigned byte 0..255
	 */
	unsigned char ReceptionQuality;
	/**
	 * Enumeration 0..4
	 * 0 TMC undecoded
	 * 1 TMC lost
	 * 2 TMC no
	 * 3 TMC free
	 * 4 TMC pay
	 */
	clCMEnum_TMC TMC;
	/**
	 * Unsigned word 0x0f20..0x0f3f
	 */
	unsigned short PresetListForAcmp;
	/**
	 * Unsigned byte 0..255
	 */
	unsigned char PresetAcmp;
	/**
	 * Signed byte -127..+128
	 */
	signed char LevelCompensation;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char HDTextEncoding;
	/**
	 * Boolean(1 byte)
	 */
	unsigned char HDNumberOfAudioPrograms;
	/**
	 * Unsigned byte 0..255
	 */
	unsigned char Drmlanguage;
	/**
	 * 24-bit field identifies the language of the target audience of the service according to ISO 639-2
	 */
	clCMEnum_DrmlanguageCode DrmlanguageCode;
	/**
	 * 16-bit field identifies the country of origin of the service (the site of the studio) according to ISO 3166
	 * using two lower case characters as specified by ISO/IEC 8859-1.
	 */
	clCMEnum_DrmCountryCode DrmCountryCode;
};

#endif
