///////////////////////////////////////////////////////////
//  clNotificationStatus.h
//  Implementation of the Class clNotificationStatus
//  Created on:      10-Feb-2015 6:06:46 PM
///////////////////////////////////////////////////////////

#if !defined(EA_F8B40F2D_4527_4721_A428_F967EE3AE6B7__INCLUDED_)
#define EA_F8B40F2D_4527_4721_A428_F967EE3AE6B7__INCLUDED_

#include "clADRMsgPayload.h"
#include "clByteConverter.h"
#include "types/clCMEnumTypes.h"
#include <string.h>

class clNotificationStatus : public clADRMsgPayload
{

public:
	/**
	 * Constructor
	 */
	clNotificationStatus();
	/**
	 * Destructor
	 */
	virtual ~clNotificationStatus();
	/**
	 * Unsigned word 0..0xffff
	 * ID of function to be registered
	 */
	unsigned short FktID;
	/**
	 * Stream 0..n ClientID1, ClientID2, ... ClientIDn
	 */
	tunerVector<unsigned short> ClientIDList;
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * Set Fkt Id
	 */
	void setFktID(unsigned short newFktID);
	/**
	 * Set Client Id list
	 */
	void setClientIDList(tunerVector<unsigned short> newClientIDList);
	/**
	 * Read Fkt Id
	 */
	unsigned short getFktID() const;
	/**
	 * Read Client Id list
	 */
	tunerVector<unsigned short> getClientIDList() const;
};
#endif // !defined(EA_F8B40F2D_4527_4721_A428_F967EE3AE6B7__INCLUDED_)
