///////////////////////////////////////////////////////////
//  clNotificationSet.cpp
//  Implementation of the Class clNotificationSet
//  Created on:      10-Feb-2015 3:50:02 PM
///////////////////////////////////////////////////////////

#include "clNotificationSet.h"


clNotificationSet::clNotificationSet() : ClientID(0){

}

clNotificationSet::~clNotificationSet(){

}

tunerVector<unsigned char> clNotificationSet::oSerialize(){

	tunerVector<unsigned char> Payload;

	vAddShort(Payload, (short)ClientID);

	Payload.push_back(Control.enType);

	for(tunerVector<unsigned short>::iterator it=FktIDList.begin(); it != FktIDList.end(); it++)
		vAddShort(Payload, (short)(*it));

	return  Payload;
}

short clNotificationSet::u16GetSize(){

	short size=0;

	size = (short)(( FktIDList.size() * sizeof(unsigned short) ) + sizeof(ClientID) + Control.getSize());

	return size;
}

void clNotificationSet::vConstruct(tunerVector<unsigned char> /*bitStream*/){

}

void clNotificationSet::setFktIDs(tunerVector<unsigned short> newListFktIDs)
{
	FktIDList.assign(newListFktIDs.begin(), newListFktIDs.end());
}

void clNotificationSet::setClientID(unsigned short newClientID)
{
	ClientID = newClientID;
}

void clNotificationSet::setControl(clCMEnum_Control::enControl newControl)
{
	Control.enType = newControl;
}