///////////////////////////////////////////////////////////
//  clCMVersionInfoStatus.h
//  Implementation of the Class clCMVersionInfoStatus
//  Created on:      05-Feb-2015 10:01:58 AM
///////////////////////////////////////////////////////////

#if !defined(EA_F830E8FA_8F41_4c96_9A3A_18330B32B12F__INCLUDED_)
#define EA_F830E8FA_8F41_4c96_9A3A_18330B32B12F__INCLUDED_

#include "clADRMsgPayload.h"
#include "clByteConverter.h"
#include "datatypes/tString.h"

#define VERSIONINFO_LEN	64

class clCMVersionInfoStatus : public clADRMsgPayload
{

public:
	/**
	 * Constructor
	 */
	clCMVersionInfoStatus();
	/**
	 * Copy Constructor
	 */
	clCMVersionInfoStatus(tunerString newSWVersion, tunerString newHWVersion);
	/**
	 * Destructor
	 */
	virtual ~clCMVersionInfoStatus();
	/**
	 * String of Software version fixed length 64 characters
	 */
	tunerString SoftwareVersion;
	/**
	 * String of Hardware version fixed length 64 characters
	 */
	tunerString HardwareVersion;
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * Read Software version
	 */
	const char* getSoftwareVersion() const;
	/**
	 * Read Hardware version
	 */
	const char* getHardwareVersion() const;
	/**
	 * Set Software version
	 */
	void setSoftwareVersion(tunerString newSWVersion);
	/**
	 * Set Hardware version
	 */
	void setHardwareVersion(tunerString newHWVersion);

};
#endif // !defined(EA_F830E8FA_8F41_4c96_9A3A_18330B32B12F__INCLUDED_)
