///////////////////////////////////////////////////////////
//  clCMTuningActionConfigurationStatus.h
//  Implementation of the Class clCMTuningActionConfigurationStatus
//  Created on:      08-Apr-2015 2:55:26 PM
///////////////////////////////////////////////////////////

#if !defined(EA_FC458EAB_1A04_4888_B1E0_BEBFC8204D03__INCLUDED_)
#define EA_FC458EAB_1A04_4888_B1E0_BEBFC8204D03__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMADRBaseTypes.h"

class clCMTuningActionConfigurationStatus : public clADRMsgPayload
{

public:
	/**
	 * Stream of Tuning action configuration
	 */
	clCMADRBaseType_TuningActionConfigurationData Data;
	/**
	 * Pos={x, y}, range: x=0..13, y=0
	 */
	clCMADRBaseType_Pos Pos;

	clCMTuningActionConfigurationStatus();
	virtual ~clCMTuningActionConfigurationStatus();
	/**
	 * serialize the data stream
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * Set Data
	 */
	void setData(clCMADRBaseType_TuningActionConfigurationData newData);
	/**
	 * Read Data
	 */
	clCMADRBaseType_TuningActionConfigurationData getData();
	/**
	 * Set Position
	 */
	void setPosition(clCMADRBaseType_Pos newPos);
	/**
	 * returns the size of the data stream
	 */
	short u16GetSize();
	/**
	 * construct the data stream
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	void ConstrcutIndividualParameters(unsigned short &pos, unsigned char x, unsigned char y, tunerVector<unsigned char> bitStream);
	bool bConstructAllElements(unsigned char x, unsigned char y);
	void ConstructNumberOfSeekPeriods(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos);
	void ConstructScantime(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos);
	void ConstructAfBestDelayTime(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos);
	void ConstructTPSeekStrategy(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos);
	void ConstructPtyFilter(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos);
	void ConstructTuningSwitches(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos);
	void ConstructAutoSeekStepDelay(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos);
	void ConstructManualStepDelay(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos);
	void ConstructWrongPiAcceptDelay(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos);
	void ConstructNONRDSdetectionTimer(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos);
	void ConstructTPSeekAfterRDSlostTimer(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos);
	void ConstructAMStationInListRemoveTimer(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos);
	void ConstructScrollingPSdetectionTimer(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos);
};
#endif // !defined(EA_FC458EAB_1A04_4888_B1E0_BEBFC8204D03__INCLUDED_)
