///////////////////////////////////////////////////////////
//  clCMTuningActionConfigurationSet.h
//  Implementation of the Class clCMTuningActionConfigurationSet
//  Created on:      01-Apr-2015 7:33:14 PM
///////////////////////////////////////////////////////////

#if !defined(EA_BB82F95F_8F1D_4c9e_A70F_23B7D9354C7F__INCLUDED_)
#define EA_BB82F95F_8F1D_4c9e_A70F_23B7D9354C7F__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMADRBaseTypes.h"

class clCMTuningActionConfigurationSet : public clADRMsgPayload
{

public:
	/**
	 * Pos={x, y}, range: x=0..13, y=0
	 */
	clCMADRBaseType_Pos Pos;
	/**
	 * Stream of Tuning action configuration
	 */
	clCMADRBaseType_TuningActionConfigurationData Data;

	clCMTuningActionConfigurationSet();
	virtual ~clCMTuningActionConfigurationSet();
	/**
	 * serialize the data stream
	 */
	tunerVector<unsigned char> oSerialize();
	void SerializeIndividualItems(unsigned char x, unsigned char y, tunerVector<unsigned char> &payload);
	bool bSerializeAllElements();
	void vSerializeNumberOfSeekPeriods(tunerVector<unsigned char> &payload, unsigned char xPos);
	void vSerializeScanTime(tunerVector<unsigned char> &payload, unsigned char xPos);
	void vSerializeAfBestDelayTime(tunerVector<unsigned char> &payload, unsigned char xPos);
	void vSerializeTPSeekStrategy(tunerVector<unsigned char> &payload, unsigned char xPos);
	void vSerializePtyFilter(tunerVector<unsigned char> &payload, unsigned char xPos);
	void vSerializeTuningSwitches(tunerVector<unsigned char> &payload, unsigned char xPos);
	void vSerializeAutoSeekStepDelay(tunerVector<unsigned char> &payload, unsigned char xPos);
	void vSerializeManualStepDelay(tunerVector<unsigned char> &payload, unsigned char xPos);
	void vSerializeWrongPiAcceptDelay(tunerVector<unsigned char> &payload, unsigned char xPos);
	void vSerializeNONRDSdetectionTimer(tunerVector<unsigned char> &payload, unsigned char xPos);
	void vSerializeTPSeekAfterRDSlostTimer(tunerVector<unsigned char> &payload, unsigned char xPos);
	void vSerializeAMStationInListRemoveTimer(tunerVector<unsigned char> &payload, unsigned char xPos);
	void vSerializeScrollingPSdetectionTimer(tunerVector<unsigned char> &payload, unsigned char xPos);
	/**
	 * returns the size of the data stream
	 */
	short u16GetSize();
	/**
	 * constructs the data stream
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * set Position
	 */
	void setPosition(clCMADRBaseType_Pos newPos);
	/**
	 * set Data
	 */
	void setData(clCMADRBaseType_TuningActionConfigurationData newData);
};
#endif // !defined(EA_BB82F95F_8F1D_4c9e_A70F_23B7D9354C7F__INCLUDED_)
