///////////////////////////////////////////////////////////
//  clCMTestModeStatus.cpp
//  Implementation of the Class clCMTestModeStatus
//  Created on:      25-Jun-2015 1:47:10 PM
///////////////////////////////////////////////////////////

#include "clCMTestModeStatus.h"

#define STATIONNAME_LEN 8
#define TPBIT         0x01
#define TABIT         0x02
#define TMCBIT        0x04
#define DDABIT        0x08
#define AUDIOTUNERBIT 0x10

clCMTestModeStatus::clCMTestModeStatus():
Frequency(0),
PI(0),
Quality(0),
Fieldstrength(0),
Multipath(0),
NeighbourChannelDistortion(0),
AFListLength(0),
Hicut(0),
Sharx(0),
ChannelSeparation(0),
RdsErrorRate(0),
Deviation(0),
InfoBits(0){

}

clCMTestModeStatus::~clCMTestModeStatus(){

}

tunerVector<unsigned char> clCMTestModeStatus::oSerialize(){

	tunerVector<unsigned char> payload;
	return payload;
}

short clCMTestModeStatus::u16GetSize(){

	return 0;
}

void clCMTestModeStatus::vConstruct(tunerVector<unsigned char> bitStream){

	unsigned short position=0;
	unsigned char LSB=0;
	unsigned char MSB=0;

	Modulation.enType = static_cast<clCMEnum_Modulation::enModulation>(bitStream[position++]);

	Frequency = getInt(bitStream, position);
	position =(unsigned short)(position + sizeof(Frequency));

	MSB = bitStream[position++];
	LSB = bitStream[position++];
	PI = getWord(LSB, MSB);

	Quality = bitStream[position++];
	Fieldstrength = bitStream[position++];
	Multipath = bitStream[position++];
	NeighbourChannelDistortion = bitStream[position++];
	AFListLength = bitStream[position++];
	Hicut = bitStream[position++];
	Sharx = bitStream[position++];

	tunerString oString((const char *)&(bitStream[position]), STATIONNAME_LEN);
	Stationname = oString;
	position =(unsigned short)(position + STATIONNAME_LEN);

	ChannelSeparation = bitStream[position++];
	RdsErrorRate = bitStream[position++];
	Deviation = bitStream[position++];
	InfoBits = bitStream[position++];
}

clCMEnum_Modulation::enModulation clCMTestModeStatus::getModulation()
{
	return Modulation.enType;
}

unsigned int clCMTestModeStatus::getFrequency()
{
	return Frequency;
}

unsigned short clCMTestModeStatus::getPI()
{
	return PI;
}

unsigned char clCMTestModeStatus::getQuality()
{
	return Quality;
}

unsigned char clCMTestModeStatus::getFieldstrength()
{
	return Fieldstrength;
}

unsigned char clCMTestModeStatus::getMultipath()
{
	return Multipath;
}

unsigned char clCMTestModeStatus::getNeighbourChannelDistortion()
{
	return NeighbourChannelDistortion;
}

unsigned char clCMTestModeStatus::getAFListLength()
{
	return AFListLength;
}

unsigned char clCMTestModeStatus::getHicut()
{
	return Hicut;
}

unsigned char clCMTestModeStatus::getSharx()
{
	return Sharx;
}

tunerString clCMTestModeStatus::getStationname()
{
	return Stationname;
}

unsigned char clCMTestModeStatus::getChannelSeparation()
{
	return ChannelSeparation;
}

unsigned char clCMTestModeStatus::getRdsErrorRate()
{
	return RdsErrorRate;
}

unsigned char clCMTestModeStatus::getDeviation()
{
	return Deviation;
}

bool clCMTestModeStatus::bIsTPSupported()
{
	return (InfoBits & TPBIT);
}

bool clCMTestModeStatus::bIsTAActive()
{
	return (InfoBits & TABIT);
}

bool clCMTestModeStatus::bIsTMCSupported()
{
	return (InfoBits & TMCBIT);
}

bool clCMTestModeStatus::bIsDDAActive()
{
	return (InfoBits & DDABIT);
}

bool clCMTestModeStatus::bIsAudioTunerOn()
{
	return (InfoBits & AUDIOTUNERBIT);
}
