///////////////////////////////////////////////////////////
//  clCMTaInfoStatus.h
//  Implementation of the Class clCMTaInfoStatus
//  Created on:      27-May-2015 3:01:13 PM
///////////////////////////////////////////////////////////

#if !defined(EA_959BCB45_9E23_4867_9EBE_A011240E9092__INCLUDED_)
#define EA_959BCB45_9E23_4867_9EBE_A011240E9092__INCLUDED_

#include "clADRMsgPayload.h"
#include "datatypes/tString.h"

class clCMTaInfoStatus : public clADRMsgPayload
{

public:
	/**
	 * Unsigned long 150..108000
	 */
	unsigned int Frequency;
	/**
	 * Unsigned word 0..0xffff
	 */
	unsigned short PI;
	/**
	 * String - 8 bytes size
	 */
	tunerString TaStationname;

	clCMTaInfoStatus();
	virtual ~clCMTaInfoStatus();
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * set CMTaInfoStatus Parameters
	 */
	void setFrequency(unsigned int newFrequency);
	void setPI(unsigned short newPI);
	void setTaStationname(tunerString newTaStationname);
	/**
	 * read CMTaInfoStatus Parameters
	 */
	unsigned int getFrequency();
	unsigned short getPI();
	const char * getTaStationname();

};
#endif // !defined(EA_959BCB45_9E23_4867_9EBE_A011240E9092__INCLUDED_)
