///////////////////////////////////////////////////////////
//  clCMTaInfoStatus.cpp
//  Implementation of the Class clCMTaInfoStatus
//  Created on:      27-May-2015 3:01:13 PM
///////////////////////////////////////////////////////////

#include "clCMTaInfoStatus.h"

#define TASTATIONNAME_LENGTH 8

clCMTaInfoStatus::clCMTaInfoStatus() : Frequency(0),
PI(0){

}

clCMTaInfoStatus::~clCMTaInfoStatus(){

}

tunerVector<unsigned char> clCMTaInfoStatus::oSerialize(){

	tunerVector<unsigned char> payload;
	return payload;
}

short clCMTaInfoStatus::u16GetSize(){

	return 0;
}

void clCMTaInfoStatus::vConstruct(tunerVector<unsigned char> bitStream){

	short position = 0;

	Frequency = getInt(bitStream, position);
	position =(short)(position + 4);

	unsigned char MSB = bitStream[position++];
	unsigned char LSB = bitStream[position++];
	PI = getWord(LSB, MSB);

	tunerString oString((const char *) &(bitStream[position]), TASTATIONNAME_LENGTH);
	TaStationname = oString;
	position =(short)(position + TASTATIONNAME_LENGTH);
}

void clCMTaInfoStatus::setFrequency(unsigned int newFrequency)
{
	Frequency = newFrequency;
}

void clCMTaInfoStatus::setPI(unsigned short newPI)
{
	PI = newPI;
}

void clCMTaInfoStatus::setTaStationname(tunerString newTaStationname)
{
	short StringSize = (short)newTaStationname.size();
	if(StringSize > TASTATIONNAME_LENGTH)
	{
		StringSize = TASTATIONNAME_LENGTH;
	}
	tunerString oString(newTaStationname.c_str(), StringSize);
	TaStationname = oString;
}

unsigned int clCMTaInfoStatus::getFrequency()
{
	return Frequency;
}

unsigned short clCMTaInfoStatus::getPI()
{
	return PI;
}

const char * clCMTaInfoStatus::getTaStationname()
{
	return TaStationname.c_str();
}
