///////////////////////////////////////////////////////////
//  clCMTMCStationsStatus.h
//  Implementation of the Class clCMTMCStationsStatus
//  Created on:      23-Apr-2015 4:45:15 PM
///////////////////////////////////////////////////////////

#if !defined(EA_16B4A32F_DEFC_49db_AF16_5BC04BDE4441__INCLUDED_)
#define EA_16B4A32F_DEFC_49db_AF16_5BC04BDE4441__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMADRBaseTypes.h"

class clCMTMCStationsStatus : public clADRMsgPayload
{

public:
	clCMTMCStationsStatus();
	virtual ~clCMTMCStationsStatus();
	/**
	 * Pos={x, y}
	 */
	clCMADRBaseType_Pos Pos;
	/**
	 * Stream of TMC Stations
	 */
	clCMADRBaseType_TMCStationsData Data;
	/**
	 * serialize the payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * construct the payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	void vConstructTMCStaionsDataStream(tunerVector<unsigned char> bitStream,
			unsigned short Position, unsigned char NumberOfStationInList);
	clCMADRBaseType_TMCStationsDataStream oGetTMCStationsData(tunerVector<unsigned char> bitStream,
			unsigned short &position);
	/**
	 * set TMCStationsStatus parameters
	 */
	void setPos(clCMADRBaseType_Pos newPos);
	void setData(clCMADRBaseType_TMCStationsData newData);
};
#endif // !defined(EA_16B4A32F_DEFC_49db_AF16_5BC04BDE4441__INCLUDED_)
