///////////////////////////////////////////////////////////
//  clCMSystemPresetsStatus.h
//  Implementation of the Class clCMSystemPresetsStatus
//  Created on:      20-Apr-2015 2:55:08 PM
///////////////////////////////////////////////////////////

#if !defined(EA_BC073B91_BBC0_4ac5_BE0A_94AA55FB1060__INCLUDED_)
#define EA_BC073B91_BBC0_4ac5_BE0A_94AA55FB1060__INCLUDED_

#include "clADRMsgPayload.h"
#include "datatypes/tString.h"
#include "types/clCMEnumTypes.h"

class clCMSystemPresetsStatus : public clADRMsgPayload
{

public:
	/**
	 * Unsigned word
	 */
	unsigned short FktId;
	/**
	 * Enumeration 0..1
	 */
	clCMEnum_SystemPresetType SystemPresetType;
	/**
	 * Unsigned long 150..108000
	 */
	unsigned int Frequency;
	/**
	 * String - 8 bytes size
	 */
	tunerString Sendername;
	/**
	 * Unsigned word 0 ..0xffff
	 */
	unsigned short PI;
	/**
	 * Enumeration 0..3
	 */
	clCMEnum_StationNameInfo StationNameInfo;

	clCMSystemPresetsStatus();
	virtual ~clCMSystemPresetsStatus();
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the data stream
	 */
	short u16GetSize();
	/**
	 * constructs the payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * set SystemPresetStatus parameters
	 */
	void setPI(unsigned short newPI);
	void setFktId(unsigned short newFktId);
	void setFrequency(unsigned int newFrequency);
	void setSendername(tunerString newSendername);
	void setStationNameInfo(clCMEnum_StationNameInfo::enStationNameInfo newStationNameInfo);
	void setSystemPresetType(clCMEnum_SystemPresetType::enSystemPresetType newSystemPresetType);
	/**
	 * read SystemPresetStatus parameters
	 */
	unsigned short getPI();
	unsigned short getFktId();
	unsigned int getFrequency();
	const char * getSendername();
	clCMEnum_StationNameInfo::enStationNameInfo getStationNameInfo();
	clCMEnum_SystemPresetType::enSystemPresetType getSystemPresetType();
};
#endif // !defined(EA_BC073B91_BBC0_4ac5_BE0A_94AA55FB1060__INCLUDED_)
