///////////////////////////////////////////////////////////
//  clCMSystemPresetsStatus.cpp
//  Implementation of the Class clCMSystemPresetsStatus
//  Created on:      20-Apr-2015 2:55:08 PM
///////////////////////////////////////////////////////////

#include "clCMSystemPresetsStatus.h"

#define SENDER_NAMELENGTH 8

clCMSystemPresetsStatus::clCMSystemPresetsStatus() :
FktId(0),
Frequency(0),
PI(0) {

}

clCMSystemPresetsStatus::~clCMSystemPresetsStatus(){

}

tunerVector<unsigned char> clCMSystemPresetsStatus::oSerialize(){

	tunerVector<unsigned char> payload;
	return payload;
}

short clCMSystemPresetsStatus::u16GetSize(){

	return 0;
}


void clCMSystemPresetsStatus::vConstruct(tunerVector<unsigned char> bitStream){

	unsigned char LSB = 0;
	unsigned char MSB = 0;
	short pos = 0;

	MSB = bitStream[pos++];
	LSB = bitStream[pos++];
	FktId = getWord(LSB, MSB);

	SystemPresetType.enType = static_cast<clCMEnum_SystemPresetType::enSystemPresetType>(bitStream[pos++]);

	Frequency = getInt(bitStream, pos);
	pos =(short)(pos + sizeof(Frequency));

	tunerString oSendername((const char *)&(bitStream[pos]), SENDER_NAMELENGTH);
	Sendername = oSendername;
	pos =(short)(pos + SENDER_NAMELENGTH);

	MSB = bitStream[pos++];
	LSB = bitStream[pos++];
	PI = getWord(LSB, MSB);

	StationNameInfo.enType = static_cast<clCMEnum_StationNameInfo::enStationNameInfo>(bitStream[pos++]);
}

void clCMSystemPresetsStatus::setPI(unsigned short newPI){

	PI = newPI;
}

void clCMSystemPresetsStatus::setFktId(unsigned short newFktId){

	FktId = newFktId;
}

void clCMSystemPresetsStatus::setFrequency(unsigned int newFrequency){

	Frequency = newFrequency;
}

void clCMSystemPresetsStatus::setSendername(tunerString newSendername){

	unsigned short stringSize = (unsigned short)newSendername.size();
	if (newSendername.size() > SENDER_NAMELENGTH)
	{
		stringSize = SENDER_NAMELENGTH;
	}
	tunerString oString(newSendername.c_str(), stringSize);
	Sendername = oString;
}

void clCMSystemPresetsStatus::setStationNameInfo(clCMEnum_StationNameInfo::enStationNameInfo newStationNameInfo){

	StationNameInfo.enType = newStationNameInfo;
}

void clCMSystemPresetsStatus::setSystemPresetType(clCMEnum_SystemPresetType::enSystemPresetType newSystemPresetType){

	SystemPresetType.enType = newSystemPresetType;
}

unsigned short clCMSystemPresetsStatus::getPI(){

	return PI;
}

unsigned short clCMSystemPresetsStatus::getFktId(){

	return FktId;
}

unsigned int clCMSystemPresetsStatus::getFrequency(){

	return Frequency;
}

const char * clCMSystemPresetsStatus::getSendername(){

	return Sendername.c_str();
}

clCMEnum_StationNameInfo::enStationNameInfo clCMSystemPresetsStatus::getStationNameInfo(){

	return StationNameInfo.enType;
}

clCMEnum_SystemPresetType::enSystemPresetType clCMSystemPresetsStatus::getSystemPresetType(){

	return SystemPresetType.enType;
}
