///////////////////////////////////////////////////////////
//  clCMSurveilTPStatus.h
//  Implementation of the Class clCMSurveilTPStatus
//  Created on:      27-May-2015 11:11:29 AM
///////////////////////////////////////////////////////////

#if !defined(EA_0CCF0B65_9C9D_434f_A65A_C2B409B6E3AE__INCLUDED_)
#define EA_0CCF0B65_9C9D_434f_A65A_C2B409B6E3AE__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMEnumTypes.h"

class clCMSurveilTPStatus : public clADRMsgPayload
{

public:
	/**
	 * Unsigned word 0..0xffff
	 */
	unsigned short PI;
	/**
	 * Enumeration 0..1
	 * 0 Start
	 * 1 Stop
	 */
	clCMEnum_StartStop StartStop;
	/**
	 * Enumeration 0..n
	 */
	clCMEnum_Strategy Strategy;

	clCMSurveilTPStatus();
	virtual ~clCMSurveilTPStatus();
	/**
	 * serialize the data stream
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the data stream
	 */
	short u16GetSize();
	/**
	 * construct the data stream
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * set SurveilTPSet parameters
	 */
	void setPI(unsigned short newPI);
	void setStartStop(clCMEnum_StartStop::enStartStop newStartStop);
	void setStrategy(clCMEnum_Strategy::enStrategy newStrategy);
	/**
	 * read SurveilTPSet parameters
	 */
	unsigned short getPI();
	clCMEnum_StartStop::enStartStop getStartStop();
	clCMEnum_Strategy::enStrategy getStrategy();

};
#endif // !defined(EA_0CCF0B65_9C9D_434f_A65A_C2B409B6E3AE__INCLUDED_)
