///////////////////////////////////////////////////////////
//  clCMSurveilTPSet.h
//  Implementation of the Class clCMSurveilTPSet
//  Created on:      27-May-2015 10:01:51 AM
///////////////////////////////////////////////////////////

#if !defined(EA_A74E1419_884E_48fb_8732_50989506D3A4__INCLUDED_)
#define EA_A74E1419_884E_48fb_8732_50989506D3A4__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMEnumTypes.h"

class clCMSurveilTPSet : public clADRMsgPayload
{

public:
	/**
	 * Unsigned word 0..0xffff
	 */
	unsigned short PI;
	/**
	 * Enumeration 0..1
	 * 0 Start
	 * 1 Stop
	 */
	clCMEnum_StartStop StartStop;
	/**
	 * Enumeration 0..n
	 */
	clCMEnum_Strategy Strategy;

	clCMSurveilTPSet();
	virtual ~clCMSurveilTPSet();
	/**
	 * serialize the data stream
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the data stream
	 */
	short u16GetSize();
	/**
	 * construct the data stream
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * set SurveilTPSet parameters
	 */
	void setPI(unsigned short newPI);
	void setStartStop(clCMEnum_StartStop::enStartStop newStartStop);
	void setStrategy(clCMEnum_Strategy::enStrategy newStrategy);

};
#endif // !defined(EA_A74E1419_884E_48fb_8732_50989506D3A4__INCLUDED_)
