///////////////////////////////////////////////////////////
//  clCMStationsListStatus.h
//  Implementation of the Class clCMStationsListStatus
//  Created on:      19-May-2015 12:22:03 PM
///////////////////////////////////////////////////////////

#if !defined(EA_35EE1753_EA59_4d94_B217_2A29FC4E8118__INCLUDED_)
#define EA_35EE1753_EA59_4d94_B217_2A29FC4E8118__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMADRBaseTypes.h"

class clCMStationsListStatus : public clADRMsgPayload
{

public:
	/**
	 * X=0..NMAX, y=0..18
	 */
	clCMADRBaseType_Pos Pos;
	/**
	 * Stream
	 */
	tunerVector<clCMADRBaseType_StationsListData> Data;
	/**
	 * Unsigned byte 0..7
	 */
	unsigned char ListId;

	clCMStationsListStatus();
	virtual ~clCMStationsListStatus();
	/**
	 * serialize the payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * construct the payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	void vConstructData(tunerVector<unsigned char>& bitStream, unsigned short& position);
	void vConstructAllValues(tunerVector<unsigned char>& bitStream, unsigned short& position);
	void vConstructSelectedValues(tunerVector<unsigned char>& bitStream, unsigned short& position);
	void vConstructRow(tunerVector<unsigned char>& bitStream, unsigned short& position);
	void vConstructColumn(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position);
	void vConstructSelected(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData);
	void vConstructModulationType(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData);
	void vConstructFrequency(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData);
	void vConstructSendername_HDCallSign_DRMServiceLabel(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData);
	void vConstructSendernameInfo(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData);
	void vConstructRDS_HD_DRM_Pty(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData);
	void vConstructPI_HDStationId_DRMServiceId(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData);
	void vConstructTpInfo(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData);
	void vConstructReceptionQuality(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData);
	void vConstructTMC(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData);
	void vConstructPresetListForAcmp(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData);
	void vConstructPresetAcmp(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData);
	void vConstructLevelCompensation(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData);
	void vConstructHDTextEncoding(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData);
	void vConstructHDNumberOfAudioPrograms(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData);
	void vConstructDrmlanguage(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData);
	void vConstructDrmlanguageCode(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData);
	void vConstructDrmCountryCode(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData);

	bool bIsAllElementsSent();
	bool bIsAllValuesSent();
	/**
	 * set StationsListStatus parameters
	 */
	void setPos(clCMADRBaseType_Pos newPos);
	void setListId(unsigned char newListId);
	void setData(tunerVector<clCMADRBaseType_StationsListData> newData);
	/**
	 * read StationsListStatus parameters
	 */
	clCMADRBaseType_Pos getPos();
	unsigned char getListId();
	tunerVector<clCMADRBaseType_StationsListData> getData();

};
#endif // !defined(EA_35EE1753_EA59_4d94_B217_2A29FC4E8118__INCLUDED_)
