///////////////////////////////////////////////////////////
//  clCMStationsList.cpp
//  Implementation of the Class clCMStationsList
//  Created on:      16-Jan-2015 11:19:42 AM
//  Original author: pmn3kor
///////////////////////////////////////////////////////////

#include "clCMStationsList.h"
#include "datatypes/tAlgorithm.h"

clCMStationsList::clCMStationsList(){
	PosX = 0;
	PosY = 0;
	u16ListID = 0x0f20;
	u8Data = 0;
}



clCMStationsList::~clCMStationsList(){

}





unsigned char clCMStationsList::GetPosX(){

	return PosX;
}


unsigned char clCMStationsList::GetPosY(){

	return PosY;
}


unsigned short clCMStationsList::Getu16ListID(){

	return u16ListID;
}


unsigned char clCMStationsList::Getu8Data(){

	return u8Data;
}


/**
 * returns the size of the data stream
 */
tunerVector<unsigned char> clCMStationsList::oSerialize(){

	tunerVector<unsigned char> payloadData;
	payloadData.push_back(PosX);
	payloadData.push_back(PosY);
	payloadData.push_back(u8Data);
	payloadData.push_back(getMSB(u16ListID));
	payloadData.push_back(getLSB(u16ListID));
	return payloadData;
}


void clCMStationsList::SetPosX(unsigned char newVal){

	PosX = newVal;
}


void clCMStationsList::SetPosY(unsigned char newVal){

	PosY = newVal;
}


void clCMStationsList::Setu16ListID(unsigned short newVal){

	u16ListID = newVal;
}


void clCMStationsList::Setu8Data(unsigned char newVal){

	u8Data = newVal;
}


/**
 * returns the size of the payload
 */

short clCMStationsList::u16GetSize(){

	return (sizeof(PosX) + sizeof(PosY) + sizeof(u16ListID) + sizeof(u8Data));
}

void clCMStationsList::vConstruct(tunerVector<unsigned char> bitStream){
	
   short index = 0;
   PosX = bitStream[index++];
   PosY = bitStream[index++];
   u8Data = bitStream[index++];
   unsigned char MSB = bitStream[index++];
   unsigned char LSB = bitStream[index++];
   u16ListID = getWord(LSB, MSB);
}

