///////////////////////////////////////////////////////////
//  clCMStationListConfigStartResult.h
//  Implementation of the Class clCMStationListConfigStartResult
//  Created on:      13-Apr-2015 7:16:37 PM
///////////////////////////////////////////////////////////

#if !defined(EA_80EF6B8D_1404_4ae8_BBC2_65A3DF318133__INCLUDED_)
#define EA_80EF6B8D_1404_4ae8_BBC2_65A3DF318133__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMEnumTypes.h"

class clCMStationListConfigStartResult : public clADRMsgPayload
{

public:
	/**
	 * Unsigned byte 0..7
	 */
	unsigned char ListId;
	/**
	 * Boolean(4 byte)
	 */
	unsigned int Band;
	/**
	 * Enumeration 0..7
	 * 0 All
	 * 1 RDS only
	 * 2 RDS and NON-RDS
	 * 3 TP station (both Self-TP and EON-TP) only
	 * 4 TP-Self station only
	 * 5 TMC station only
	 * 6 r.f.u.
	 * 7 None
	 */
	clCMEnum_AnalogFilter AnalogFilter;
	/**
	 * Boolean(1 byte)
	 */
	unsigned char DigitalFilter;
	/**
	 * Boolean(4 bytes)
	 */
	unsigned int PtyFilter;
	/**
	 * Enumeration 0..7
	 * 0 PS_ASCENDING
	 * 1 PI_ASCENDING
	 * 2 FIELDSTRENGTH_ASCENDING
	 * 3 FREQUENCY_ASCENDING
	 * 4 PS_DESCENDING
	 * 5 PI_ DESCENDING
	 * 6 FIELDSTRENGTH_ DESCENDING
	 * 7 FREQUENCY_ DESCENDING
	 */
	clCMEnum_Sorting Sorting;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char rfu_byte_0;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char rfu_byte_1;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char rfu_byte_2;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char rfu_byte_3;

	clCMStationListConfigStartResult();
	virtual ~clCMStationListConfigStartResult();
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * set StationListConfigStartResult parameters
	 */
	void setListId(unsigned char newListId);
	void setBand(unsigned int newBand);
	void setAnalogFilter(clCMEnum_AnalogFilter::enAnalogFilter newAnalogFilter);
	void setDigitalFilter(unsigned char newDigitalFilter);
	void setPtyFilter(unsigned int newPtyFilter);
	void setSorting(clCMEnum_Sorting::enSorting newSorting);
	void setrfu_byte_0(unsigned char newrfu_byte_0);
	void setrfu_byte_1(unsigned char newrfu_byte_1);
	void setrfu_byte_2(unsigned char newrfu_byte_2);
	void setrfu_byte_3(unsigned char newrfu_byte_3);
};
#endif // !defined(EA_80EF6B8D_1404_4ae8_BBC2_65A3DF318133__INCLUDED_)
