///////////////////////////////////////////////////////////
//  clCMSpecialDiagnosisModeStatus.h
//  Implementation of the Class clCMSpecialDiagnosisModeStatus
//  Created on:      25-Jun-2015 9:59:08 AM
///////////////////////////////////////////////////////////

#if !defined(EA_A4808482_5B65_4872_BC20_5E02991701E3__INCLUDED_)
#define EA_A4808482_5B65_4872_BC20_5E02991701E3__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMEnumTypes.h"

class clCMSpecialDiagnosisModeStatus : public clADRMsgPayload
{

public:
	/**
	 * Enumeration 0..2
	 * 0 NORMAL_MODE
	 * 1 MEASURE_MODE
	 * 2 SINGLE_TUNER_MODE
	 */
	clCMEnum_SpecialDiagnosisMode Mode;
	/**
	 * Unsigned byte 0..3
	 */
	unsigned char PhysicalTunerId;

	clCMSpecialDiagnosisModeStatus();
	virtual ~clCMSpecialDiagnosisModeStatus();
	/**
	 * serialize the payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * construct the payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * read SpecialDiagnosisModeSet parameters
	 */
	clCMEnum_SpecialDiagnosisMode::enMode getMode();
	unsigned char getPhysicalTunerId();

};
#endif // !defined(EA_A4808482_5B65_4872_BC20_5E02991701E3__INCLUDED_)
