///////////////////////////////////////////////////////////
//  clCMSpecialDiagnosisModeSet.h
//  Implementation of the Class clCMSpecialDiagnosisModeSet
//  Created on:      25-Jun-2015 9:58:47 AM
///////////////////////////////////////////////////////////

#if !defined(EA_3898558A_4267_4666_8335_C5AC2B3D8F5A__INCLUDED_)
#define EA_3898558A_4267_4666_8335_C5AC2B3D8F5A__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMEnumTypes.h"

class clCMSpecialDiagnosisModeSet : public clADRMsgPayload
{

public:
	/**
	 * Enumeration 0..2
	 * 0 NORMAL_MODE
	 * 1 MEASURE_MODE
	 * 2 SINGLE_TUNER_MODE
	 */
	clCMEnum_SpecialDiagnosisMode Mode;
	/**
	 * Unsigned byte 0..3
	 */
	unsigned char PhysicalTunerId;

	clCMSpecialDiagnosisModeSet();
	virtual ~clCMSpecialDiagnosisModeSet();
	/**
	 * serialize the payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * construct the payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * set SpecialDiagnosisModeSet parameters
	 */
	void setMode(clCMEnum_SpecialDiagnosisMode::enMode newMode);
	void setPhysicalTunerId(unsigned char newPhysicalTunerId);

};
#endif // !defined(EA_3898558A_4267_4666_8335_C5AC2B3D8F5A__INCLUDED_)
