///////////////////////////////////////////////////////////
//  clCMSpecialDiagnosisMode.h
//  Implementation of the Class clCMSpecialDiagnosisMode
//  Created on:      12-Jan-2015 14:47:42
//  Original author: pad1cob
///////////////////////////////////////////////////////////
#ifndef clCMSpecialDiagnosisMode_h
#define clCMSpecialDiagnosisMode_h

#include "clADRMsgPayload.h"
#include "datatypes/tVector.h"

/**
 * Class used to contain information related to the Seek function
 * @author pad1cob
 * @version 1.0
 * @created 12-Jan-2015 14:47:42
 */
class clCMSpecialDiagnosisMode : public clADRMsgPayload
{

public:
	clCMSpecialDiagnosisMode();
	virtual ~clCMSpecialDiagnosisMode();

	/**
	 * returns the size of the data stream
	 */
	virtual tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	virtual short u16GetSize();
	/**
	 * 
	 * @param bitStream
	 */
	virtual void vConstruct(tunerVector<unsigned char> bitStream);


   enum tenMode {
      NORMAL_MODE = 0,
      MEASURE_MODE,
      SINGLETUNER_MODE
   };

   unsigned char Mode;
   unsigned char PhysicalTunerId;

};
#endif
