///////////////////////////////////////////////////////////
//  clCMSetUserOptionsStatus.h
//  Implementation of the Class clCMSetUserOptionsStatus
//  Created on:
///////////////////////////////////////////////////////////

#ifndef CLCMSETUSEROPTIONSSTATUS_H_
#define CLCMSETUSEROPTIONSSTATUS_H_

#include "clADRMsgPayload.h"

class clCMSetUserOptionsStatus : public clADRMsgPayload
{

public:
	/**
	 * Constructor
	 */
	clCMSetUserOptionsStatus();
	/**
	 * Destructor
	 */
	virtual ~clCMSetUserOptionsStatus();

	/**
	 * Boolean (4 Bytes)
	 * Bit 0 True Change LSM to new user
	 *      False Do not change LSM
	 * Bit 1 True Change the preset list content to new user
	 *      False Do not change the preset list content
	 * Bit 2 True New user is guest user
	 *      False New user is standart user (not guest user)
	 * (3..31) TBD
	 *
	 */
	unsigned int UserOptions;

	unsigned char UserId;
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * Set UserOptions
	 */
	void setUserOptions(unsigned int newUserOptions);
	/**
	 * Set UserId
	 */
	void setUserId(unsigned char newUserId);
	/**
	 * Read UserOptions
	 */
	unsigned int getUserOptions() const;
	/**
	 * Read UserId
	 */
	unsigned char getUserId() const;
};
#endif // !defined(CLCMSETUSEROPTIONSSTATUS_H_)
