///////////////////////////////////////////////////////////
//  clCMSetConfigurationStartResult.cpp
//  Implementation of the Class clCMSetConfigurationStartResult
//  Created on:      26-Jun-2015 3:42:40 PM
///////////////////////////////////////////////////////////

#include "clCMSetConfigurationStartResult.h"

#define VERSIONINFO_LEN 16

clCMSetConfigurationStartResult::clCMSetConfigurationStartResult()
    : NumberOfBytes(0){

}

clCMSetConfigurationStartResult::~clCMSetConfigurationStartResult(){

}

tunerVector<unsigned char> clCMSetConfigurationStartResult::oSerialize(){

	tunerVector<unsigned char> payload;
	char *pStr = const_cast<char *>(VersionInfo.c_str());

	if(VersionInfo.size() < VERSIONINFO_LEN)
	{
		int index=0;
		for(; index < (int)VersionInfo.size(); index++)
		{
			payload.push_back(pStr[index]);
		}
		for(; index < VERSIONINFO_LEN; index++)
		{
			payload.push_back((unsigned char)0);
		}
	}
	else
	{
		vAddString(payload, (unsigned char *)pStr, VERSIONINFO_LEN);
	}
	vAddShort(payload, NumberOfBytes);
	payload.insert(payload.end(), Byte0_n.begin(), Byte0_n.begin() + NumberOfBytes);

	unsigned short payloadDataSize = (unsigned short)payload.size();
	payload.insert(payload.begin(), getLSB(payloadDataSize));
	payload.insert(payload.begin(), getMSB(payloadDataSize));

	return payload;
}

short clCMSetConfigurationStartResult::u16GetSize(){

	return 0;
}

bool clCMSetConfigurationStartResult::bIsStaticSize(){

	return false;
}

void clCMSetConfigurationStartResult::vConstruct(tunerVector<unsigned char> /*bitStream*/){

}

void clCMSetConfigurationStartResult::setVersionInfo(tunerString newVersionInfo)
{
	unsigned short StrSize = (unsigned short)newVersionInfo.size();
	if(StrSize > VERSIONINFO_LEN)
	{
		StrSize = VERSIONINFO_LEN;
	}
	tunerString oString(newVersionInfo.c_str(), StrSize);
	VersionInfo = oString;
}

void clCMSetConfigurationStartResult::setNumberOfBytes(unsigned short newNumberOfBytes)
{
	NumberOfBytes = newNumberOfBytes;
}

void clCMSetConfigurationStartResult::setByte0_n(tunerVector<unsigned char> newByte0_n)
{
	Byte0_n.assign(newByte0_n.begin(), newByte0_n.end());
}
