///////////////////////////////////////////////////////////
//  clCMSetConfigSectionsStartResult.h
//  Implementation of the Class clCMSetConfigSectionsStartResult
//  Created on:      26-Jun-2015 3:42:40 PM
///////////////////////////////////////////////////////////

#if !defined(CMSetConfigSectionsStartResult__INCLUDED_)
#define CMSetConfigSectionsStartResult__INCLUDED_

#include "clADRMsgPayload.h"
#include "datatypes/tString.h"

class clCMSetConfigSectionsStartResult : public clADRMsgPayload
{

public:
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char rfu_byte_0;
	unsigned char rfu_byte_1;
	unsigned char rfu_byte_2;
	unsigned char rfu_byte_3;
	unsigned char rfu_byte_4;
	unsigned char rfu_byte_5;
	unsigned char rfu_byte_6;
	unsigned char rfu_byte_7;
	/**
	 * String of size 16 bytes
	 */
	tunerString VersionInfo;
	/**
	 * Unsigned word 0..0xfff9
	 */
	unsigned short NumberOfBytes;
	/**
	 * Unsigned byte 0..0xff
	 */
	tunerVector<unsigned char> Byte0_n;

	clCMSetConfigSectionsStartResult();
	virtual ~clCMSetConfigSectionsStartResult();
	/**
	 * serialize the payload
	 */
	tunerVector<unsigned char> oSerialize();
	void oSerializeRFU_bytes(tunerVector<unsigned char> &payload);
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	bool bIsStaticSize();
	/**
	 * construct the payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * set SetconfigurationStartResult parameters
	 */
	void setVersionInfo(tunerString newVersionInfo);
	void setNumberOfBytes(unsigned short newNumberOfBytes);
	void setByte0_n(tunerVector<unsigned char> newByte0_n);

};
#endif // !defined(EA_5805643A_EBD1_4b9c_917F_A2BE29366EFC__INCLUDED_)
