/*
 * clCMPresetListContentUpdateStartResult.cpp
 *
 *  Created on: 03-May-2018
 *      Author: aso9kor
 */

#include <ADRMsg/clCMPresetListContentUpdateStartResult.h>

clCMPresetListContentUpdateStartResult::clCMPresetListContentUpdateStartResult()
{
	m_u8Result = 0;
	m_u8UserID = 0;
	m_u8TypeOfParameterSet = 0;
	m_u8NumberOfPresetsToUpdate = 0;
}

clCMPresetListContentUpdateStartResult::~clCMPresetListContentUpdateStartResult()
{

}

tunerVector<unsigned char> clCMPresetListContentUpdateStartResult::oSerialize()
{
	return payload;
}

short  clCMPresetListContentUpdateStartResult::u16GetSize()
{
	return (short)payload.size();
}

void clCMPresetListContentUpdateStartResult::vConstruct(tunerVector<unsigned char> bitStream)
{
	   short index = 0;
	   m_u8Result = bitStream[index];
}
void clCMPresetListContentUpdateStartResult::vsetNumberOfPresetsToUpdate(unsigned char u8UserID,unsigned char u8TypeOfParameterSet, unsigned char u8NumberOfPresetsToUpdate)
{
	m_u8UserID = u8UserID;
	m_u8TypeOfParameterSet = u8TypeOfParameterSet;
	m_u8NumberOfPresetsToUpdate = u8NumberOfPresetsToUpdate;
	payload.clear();
	oSerializeUserID();
	oSerializeTypeOfParameterSet();
	oSerializeNumberOfPresetsToUpdate();

}
void clCMPresetListContentUpdateStartResult::vPopulate(clCMPresetListContentUpdate_Data &objclCMPresetListContentUpdate_Data)
{
	char *pStr = const_cast<char *>(objclCMPresetListContentUpdate_Data.ServiceName.c_str());

	vAddShort(payload, (unsigned short)objclCMPresetListContentUpdate_Data.FktIdOfList);
	payload.push_back(objclCMPresetListContentUpdate_Data.ElementID);
	payload.push_back(objclCMPresetListContentUpdate_Data.ModulationType.enType);
	payload.push_back(objclCMPresetListContentUpdate_Data.Band);
	vAddInt(payload, (unsigned int)objclCMPresetListContentUpdate_Data.Frequency);
	vAddInt(payload, (unsigned int)objclCMPresetListContentUpdate_Data.SID);
	payload.push_back(objclCMPresetListContentUpdate_Data.ProgramService);
	payload.push_back((unsigned char)objclCMPresetListContentUpdate_Data.NumberOfCharactersInStationName);

	if( objclCMPresetListContentUpdate_Data.NumberOfCharactersInStationName > 0)
	{
		payload.push_back(objclCMPresetListContentUpdate_Data.ServiceNameEncoding);
		vAddString(payload, (unsigned char *)pStr, (unsigned char)objclCMPresetListContentUpdate_Data.NumberOfCharactersInStationName);
	}
}

void clCMPresetListContentUpdateStartResult::oSerializeUserID()
{
	payload.push_back(m_u8UserID);
}
void clCMPresetListContentUpdateStartResult::oSerializeTypeOfParameterSet()
{
	payload.push_back(m_u8TypeOfParameterSet);
}
void clCMPresetListContentUpdateStartResult::oSerializeNumberOfPresetsToUpdate()
{
	payload.push_back(m_u8NumberOfPresetsToUpdate);
}

