///////////////////////////////////////////////////////////
//  clCMHDTestModeStatus.h
//  Implementation of the Class clCMHDTestModeStatus
//  Created on:      26-Feb-2015 5:46:59 PM
///////////////////////////////////////////////////////////

#if !defined(EA_06D7FF81_FAD0_46b1_94FC_25363692CDED__INCLUDED_)
#define EA_06D7FF81_FAD0_46b1_94FC_25363692CDED__INCLUDED_

#include "clADRMsgPayload.h"
#include "datatypes/tString.h"
#include "types/clCMEnumTypes.h"

class clCMHDTestModeStatus : public clADRMsgPayload
{

public:
	/**
	 * Constructor
	 */
	clCMHDTestModeStatus();
	/**
	 * Destructor
	 */
	virtual ~clCMHDTestModeStatus();
	/**
	 * String of size 8 bytes
	 */
	tunerString HDCallSign;
	/**
	 * Unsigned long word 0..0xffffffff
	 */
	unsigned int HDStationId;
	/**
	 * Boolean (1 byte)
	 * Bit 0 False MPS not available
	 *      True MPS available
	 * Bit 1 False SPS 1 not available
	 *      True SPS 1 available
	 * Bit 2..7 False SPS 2..7 not available
	 *         True SPS 2..7 available
	 *
	 */
	unsigned char AvailableAudioprograms;
	/**
	 * Enumeration 0..7
	 * 0 Audio program 1 (MPS)
	 * 1..7 Audio program 2 .. 8 (SPS)
	 */
	clCMEnum_ATHDAudioProgram ActiveAudioprogram;
	/**
	 * Unsigned byte 0..0x0f
	 * 0: poorest quality � 0xf: highest quality
	 */
	unsigned char AudioQuality;
	/**
	 * Boolean (1 Byte)
	 * Bit 0 False No HD Modulation detected
	 *        True HD Modulation detected
	 * Bit 1 False No HD data decoding possible
	 *        True HD data decoding possible
	 * Bit 2 False No HD audio decoding possible
	 *        True HD audio decoding possible
	 * Bit 3 False HD blend on digital audio signal
	 *        True HD blend on analog FM/AM audio signal
	 * Bit 4 False HD digital audio currently not muted
	 *        True HD digital audio currently muted
	 * Bit 5 False HD ball game mode not active
	 *        True HD ball game mode active
	 * Bit 6..7 Unused
	 */
	unsigned char HDStationInfoBits;
	/**
	 * Unsigned byte 0..99
	 */
	unsigned char CD_N0;

	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * Set HD call sign
	 */
	void setHDCallSign(tunerString newHDCallSign);
	/**
	 * Set HD station Id
	 */
	void setHDStationId(unsigned char newHDStationId);
	/**
	 * Set available audio programs
	 */
	void setAvailableAudioprograms(unsigned char newAvailableAudioprograms);
	/**
	 * Set active audio program
	 */
	void setActiveAudioprogram(clCMEnum_ATHDAudioProgram::enATHDAudioProgram newActiveAudioprogram);
	/**
	 * Set audio quality
	 */
	void setAudioQuality(unsigned char newAudioQuality);
	/**
	 * Set HDStationInfoBits
	 */
	void setHDStationInfoBits(unsigned char newHDStationInfoBits);
	/**
	 * Set CD No.
	 */
	void setCD_N0(unsigned char newCD_N0);
		/**
	 * Read HD call sign
	 */
	const char * getHDCallSign() const;
	/**
	 * Read HD station Id
	 */
	unsigned int getHDStationId();
	/**
	 * Read Available audio programs
	 */
	unsigned char getAvailableAudioprograms();
	/**
	 * Read Active audio program
	 */
	clCMEnum_ATHDAudioProgram::enATHDAudioProgram getActiveAudioprogram();
	/**
	 * Read Audio quality
	 */
	unsigned char getAudioQuality();
	/**
	 * Read HDStationInfoBits
	 */
	unsigned char getHDStationInfoBits();
	/**
	 * Read CD No.
	 */
	unsigned char getCD_N0();

};

#endif // !defined(EA_06D7FF81_FAD0_46b1_94FC_25363692CDED__INCLUDED_)
