///////////////////////////////////////////////////////////
//  clCMEnhancedTestModeStatus.h
//  Implementation of the Class clCMEnhancedTestModeStatus
//  Created on:      29-Jun-2015 12:21:15 PM
///////////////////////////////////////////////////////////

#if !defined(EA_3ED8F7B5_EA1E_48eb_8338_2A190503D8BD__INCLUDED_)
#define EA_3ED8F7B5_EA1E_48eb_8338_2A190503D8BD__INCLUDED_

#include "clADRMsgPayload.h"
#include "datatypes/tString.h"
#include "types/clCMEnumTypes.h"

class clCMEnhancedTestModeStatus : public clADRMsgPayload
{

public:
    /**
     * Enumeration 0..6
     * 0 UNKNOWN
     * 1 FM
     * 2 FM_NON_RDS
     * 3 AM
     * 4 DRM
     * 5 HD
     * 6 DAB
     */
    clCMEnum_Modulation Modulation;
    /**
     * Unsigned long word 150..108000
     */
    unsigned int u32Frequency;
    /**
     * Unsigned word 0..0xffff
     */
    unsigned short u16CurrentPI;
    /**
     * Unsigned word 0..0xffff
     */
    unsigned short u16TargetPI;
    /**
     * Unsigned byte 0..0xff
     */
    unsigned char u8Quality;
    /**
     * Unsigned byte 0..0xff
     */
    unsigned char u8Fieldstrength;
    /**
     * Unsigned byte 0..0xff
     */
    unsigned char u8Multipath;
    /**
     * Unsigned byte 0..0xff
     */
    unsigned char u8NeighbourChannelDistortion;
    /**
     * Unsigned byte 0..0xff
     */
    unsigned char u8AFListLength;
    /**
     * Unsigned byte 0..0xff
     */
    unsigned char u8Hicut;
    /**
     * Unsigned byte 0..0xff
     */
    unsigned char u8Sharx;
    /**
     * String of size 8 bytes
     */
    tunerString sCurrentStationname;
    /**
     * String of size 8 bytes
     */
    tunerString sFixStationname;
    /**
     * Enumeration 0..1
     * 0 Fix PS detected
     * 1 Scrolling PS detected
     */
    clCMEnum_ScrollPSStatus oScrollPSStatus;
    /**
     * Enumeration 0..1
     * 0 AF best off
     * 1 AF best on
     */
    clCMEnum_AfStatus oAfStatus;
    /**
     * Unsigned byte 0..99
     */
    unsigned char u8FmDeviation;
    /**
     * Unsigned byte 0..200
     */
    unsigned char u8RdsDeviation;
    /**
     * Signed byte -99..99
     */
    unsigned char u8IfOffset;
    /**
     * Signed byte -99..99
     */
    unsigned char u8RdsOffset;
    /**
     * Unsigned byte 0..9
     */
    unsigned char u8CoChannelStatus;
    /**
     * Unsigned byte 0..9
     */
    unsigned char u8AGC;
    /**
     * Unsigned byte 0..0xff
     */
    unsigned char u8ChannelSeparation;
    /**
     * Unsigned byte 0..0x64%
     */
    unsigned char u8RdsErrorRate;
    /**
     * Enumeration 0..3
     * 0 No diversity feature
     * 1 DMQ
     * 2 DDS
     * 3 DDA
     */
    clCMEnum_DiversityState oDiversityState;
    /**
     * Enumeration 0..3
     * 0 DDS off
     * 1 Antenna 1 selected
     * 2 Antenna 2 selected
     * 3 DDS active
     */
    clCMEnum_AntennaPathSwitch1 oAntennaPathSwitch1;
    /**
     * Enumeration 0..2
     * 0 No antenna selected
     * 1 Antenna 1 selected
     * 2 Antenna 2 selected
     */
    clCMEnum_AntennaPathSwitch2 oAntennaPathSwitch2;
    /**
     * Boolean(1 bytes)
     * Bit 0 False Unknown if station supports TP
     *        True  Station supports TP
     * Bit 1 False Unknown if station currently broadcasts a TA
     *        True Station currently broadcasts a TA
     * Bit 2 False Unknown if station supports TMC
     *        True Station supports TMC
     * Bit 3 unused
     * Bit 4 False No audio tuner
     *       True Audio tuner
     * Bit 5..7 unused
     */
    unsigned char u8InfoBits;
    /* HicutExtender */
    unsigned char u8HicutExtender;

    clCMEnhancedTestModeStatus();
    virtual ~clCMEnhancedTestModeStatus();
    /**
     * serialize payload
     */
    tunerVector<unsigned char> oSerialize();
    /**
     * returns the size of the payload
     */
    short u16GetSize();
    /**
     * constructs payload
     */
    void vConstruct(tunerVector<unsigned char> bitStream);
    /**
     * Read Enhanced Test mode parameters
     */
    clCMEnum_Modulation::enModulation getModulation();
    unsigned int getFrequency();
    unsigned short getCurrentPI();
    unsigned short getTargetPI();
    unsigned char getQuality();
    unsigned char getFieldstrength();
    unsigned char getMultipath();
    unsigned char getNeighbourChannelDistortion();
    unsigned char getAFListLength();
    unsigned char getHicut();
    unsigned char getSharx();
    tunerString getCurrentStationname();
    tunerString getFixStationname();
    clCMEnum_ScrollPSStatus::enScrollPSStatus getScrollPsStatus();
    clCMEnum_AfStatus::enAfStatus getAfStatus();
    unsigned char getFmDeviation();
    unsigned char getRdsDeviation();
    signed char getIfOffset();
    signed char getRdsOffset();
    unsigned char getCoChannelStatus();
    unsigned char getAGC();
    unsigned char getChannelSeparation();
    unsigned char getRdsErrorRate();
    clCMEnum_DiversityState::enDiversityState getDiversityState();
    clCMEnum_AntennaPathSwitch1::enAntennaPathSwitch1 getAntennaPathSwitch1();
    clCMEnum_AntennaPathSwitch2::enAntennaPathSwitch2 getAntennaPathSwitch2();
    unsigned char getInfoBits();
    unsigned char getHicutExtender();

};
#endif // !defined(EA_3ED8F7B5_EA1E_48eb_8338_2A190503D8BD__INCLUDED_)
