///////////////////////////////////////////////////////////
//  clCMEnhancedTestModeStatus.cpp
//  Implementation of the Class clCMEnhancedTestModeStatus
//  Created on:      29-Jun-2015 12:21:15 PM
///////////////////////////////////////////////////////////

#include "clCMEnhancedTestModeStatus.h"
#define STATIONNAME_LEN 8

clCMEnhancedTestModeStatus::clCMEnhancedTestModeStatus() : u32Frequency(0),
u16CurrentPI(0),
u16TargetPI(0),
u8Quality(0),
u8Fieldstrength(0),
u8Multipath(0),
u8NeighbourChannelDistortion(0),
u8AFListLength(0),
u8Hicut(0),
u8Sharx(0),
u8FmDeviation(0),
u8RdsDeviation(0),
u8IfOffset(0),
u8RdsOffset(0),
u8CoChannelStatus(0),
u8AGC(0),
u8ChannelSeparation(0),
u8RdsErrorRate(0),
u8InfoBits(0),
u8HicutExtender(0){

}

clCMEnhancedTestModeStatus::~clCMEnhancedTestModeStatus(){

}

tunerVector<unsigned char> clCMEnhancedTestModeStatus::oSerialize(){

	tunerVector<unsigned char> payload;
	return payload;
}

short clCMEnhancedTestModeStatus::u16GetSize(){

	return 0;
}

void clCMEnhancedTestModeStatus::vConstruct(tunerVector<unsigned char> bitStream){

    unsigned short position = 0;
    unsigned char LSB = 0;
    unsigned char MSB = 0;

    Modulation.enType = static_cast<clCMEnum_Modulation::enModulation>(bitStream[position++]);

    u32Frequency = getInt(bitStream, position);
    position =(unsigned short)(position + sizeof(u32Frequency));

    MSB = bitStream[position++];
    LSB = bitStream[position++];
    u16CurrentPI = getWord(LSB, MSB);

    MSB = bitStream[position++];
    LSB = bitStream[position++];
    u16TargetPI = getWord(LSB, MSB);

    u8Quality = bitStream[position++];
    u8Fieldstrength = bitStream[position++];
    u8Multipath = bitStream[position++];
    u8NeighbourChannelDistortion = bitStream[position++];
    u8AFListLength = bitStream[position++];
    u8Hicut = bitStream[position++];;
    u8Sharx = bitStream[position++];

    tunerString oCurrentStationnameStr((const char *)&(bitStream[position]), STATIONNAME_LEN);
    sCurrentStationname = oCurrentStationnameStr;
    position =(unsigned short)(position + STATIONNAME_LEN);

    tunerString oFixStationnameStr((const char *)&(bitStream[position]), STATIONNAME_LEN);
    sFixStationname = oFixStationnameStr;
    position =(unsigned short)(position + STATIONNAME_LEN);

    oScrollPSStatus.enType = static_cast<clCMEnum_ScrollPSStatus::enScrollPSStatus>(bitStream[position++]);
    oAfStatus.enType = static_cast<clCMEnum_AfStatus::enAfStatus>(bitStream[position++]);
    u8FmDeviation = bitStream[position++];
    u8RdsDeviation = bitStream[position++];
    u8IfOffset = bitStream[position++];
    u8RdsOffset = bitStream[position++];
    u8CoChannelStatus = bitStream[position++];
    u8AGC = bitStream[position++];
    u8ChannelSeparation = bitStream[position++];
    u8RdsErrorRate = bitStream[position++];
    oDiversityState.enType = static_cast<clCMEnum_DiversityState::enDiversityState>(bitStream[position++]);
    oAntennaPathSwitch1.enType = static_cast<clCMEnum_AntennaPathSwitch1::enAntennaPathSwitch1>(bitStream[position++]);
    oAntennaPathSwitch2.enType = static_cast<clCMEnum_AntennaPathSwitch2::enAntennaPathSwitch2>(bitStream[position++]);
    u8InfoBits = bitStream[position++];
    u8HicutExtender = bitStream[position++];
}

clCMEnum_Modulation::enModulation clCMEnhancedTestModeStatus::getModulation()
{
    return Modulation.enType;
}

unsigned int clCMEnhancedTestModeStatus::getFrequency()
{
    return u32Frequency;
}

unsigned short clCMEnhancedTestModeStatus::getCurrentPI()
{
    return u16CurrentPI;
}

unsigned short clCMEnhancedTestModeStatus::getTargetPI()
{
    return u16TargetPI;
}

unsigned char clCMEnhancedTestModeStatus::getQuality()
{
    return u8Quality;
}

unsigned char clCMEnhancedTestModeStatus::getFieldstrength()
{
    return u8Fieldstrength;
}

unsigned char clCMEnhancedTestModeStatus::getMultipath()
{
    return u8Multipath;
}

unsigned char clCMEnhancedTestModeStatus::getNeighbourChannelDistortion()
{
    return u8NeighbourChannelDistortion;
}

unsigned char clCMEnhancedTestModeStatus::getAFListLength()
{
    return u8AFListLength;
}

unsigned char clCMEnhancedTestModeStatus::getHicut()
{
    return u8Hicut;
}

unsigned char clCMEnhancedTestModeStatus::getSharx()
{
    return u8Sharx;
}

tunerString clCMEnhancedTestModeStatus::getCurrentStationname()
{
    return sCurrentStationname;
}

tunerString clCMEnhancedTestModeStatus::getFixStationname()
{
    return sFixStationname;
}

clCMEnum_ScrollPSStatus::enScrollPSStatus clCMEnhancedTestModeStatus::getScrollPsStatus()
{
    return oScrollPSStatus.enType;
}

clCMEnum_AfStatus::enAfStatus clCMEnhancedTestModeStatus::getAfStatus()
{
    return oAfStatus.enType;
}

unsigned char clCMEnhancedTestModeStatus::getFmDeviation()
{
    return u8FmDeviation;
}

unsigned char clCMEnhancedTestModeStatus::getRdsDeviation()
{
    return u8RdsDeviation;
}

signed char clCMEnhancedTestModeStatus::getIfOffset()
{
    return u8IfOffset;
}

signed char clCMEnhancedTestModeStatus::getRdsOffset()
{
    return u8RdsOffset;
}

unsigned char clCMEnhancedTestModeStatus::getCoChannelStatus()
{
    return u8CoChannelStatus;
}

unsigned char clCMEnhancedTestModeStatus::getAGC()
{
    return u8AGC;
}

unsigned char clCMEnhancedTestModeStatus::getChannelSeparation()
{
    return u8ChannelSeparation;
}

unsigned char clCMEnhancedTestModeStatus::getRdsErrorRate()
{
    return u8RdsErrorRate;
}

clCMEnum_DiversityState::enDiversityState clCMEnhancedTestModeStatus::getDiversityState()
{
    return oDiversityState.enType;
}

clCMEnum_AntennaPathSwitch1::enAntennaPathSwitch1 clCMEnhancedTestModeStatus::getAntennaPathSwitch1()
{
    return oAntennaPathSwitch1.enType;
}

clCMEnum_AntennaPathSwitch2::enAntennaPathSwitch2 clCMEnhancedTestModeStatus::getAntennaPathSwitch2()
{
    return oAntennaPathSwitch2.enType;
}

unsigned char clCMEnhancedTestModeStatus::getInfoBits()
{
    return u8InfoBits;
}

unsigned char clCMEnhancedTestModeStatus::getHicutExtender()
{
    return u8HicutExtender;
}
