///////////////////////////////////////////////////////////
//  clCMDrmTestModeStatus.h
//  Implementation of the Class clCMDrmTestModeStatus
//  Created on:      08-Jul-2015 8:27:58 PM
///////////////////////////////////////////////////////////

#if !defined(EA_F607A53F_07DD_49d8_93AD_790C535F949A__INCLUDED_)
#define EA_F607A53F_07DD_49d8_93AD_790C535F949A__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMADRBaseTypes.h"

class clCMDrmTestModeStatus : public clADRMsgPayload
{

public:
	/**
	 * Byte
	 * Bit 0 0 not audio tuner
	 *       1 is audio tuner
	 * Bit 1..7 r.f.u
	 */
	unsigned char TunerInfo;
	/**
	 * Unsigned long word 150..108000
	 */
	unsigned int Frequency;
	unsigned char FieldStrength;
	/**
	 * Byte
	 * ####Bit 0
	 * 0 DRM signal not detected
	 * 1 DRM signal detected
	 * #####Bit 1
	 * 0 No physical sync
	 * 1 Physical sync
	 * #####Bit 2
	 * 0 No FAC sync, channel configuration not detected
	 * 1 FAC sync, channel configuration detected
	 * #####Bit 3
	 * 0 No SDC sync, service configuration not detected
	 * 1 FAC sync, channel configuration detected
	 * #####Bit 4
	 * 0 MSC output not active
	 * 1 MSC output active
	 * Bit 5..7 r.f.u
	 */
	unsigned char SyncStatus;
	/**
	 * Byte Bit 0..2
	 * Robustness mode
	 * 0:A 1:B 2:C 3:D 4:E
	 * Bit 3..7 r.f.u
	 */
	unsigned char RobustnessMode;
	/**
	 * 3 bytes - Bit 0..19
	 * 1 bit  Base/Enhancement flag
	 * 2 bits Identity
	 * 1 bit  RM flag
	 * 3 bits Spectrum occupancy
	 * 1 bit  Interleaver depth flag
	 * 2 bits MSC mode
	 * 1 bit  SDC mode
	 * 4 bits Number of services
	 * 3 bits Reconfiguration index
	 * 1 bit  Toggle flag
	 * 1 bit  rfu
	 * Bit 20..23 r.f.u
	 */
	unsigned int ChannelParams;
	/**
	 * 6 bytes Bit 0..3  - r.f.u
	 * Bit 4..47 - Service parameters
	 * 24 bits  Service identifier
	 * 2 bits   Short Id
	 * 1 bit    Audio CA indication
	 * 4 bits   Language
	 * 1 bit    Audio/Data flag
	 * 5 bits   Service descriptor
	 * 1 bit    Data CA indication
	 * 6 bits   rfa
	 */
	tunerVector<unsigned char> Service;
	/**
	 * 65 bytes
	 * Byte 0..64 - label data. The L MSBytes contain the valid data.
	 * Byte 65 - Number of used bytes in label data = L, range 0..64
	 */
	//clCMADRBaseType_FixedLengthString ServiceLabelData;
	tunerString ServiceLabelData;
	/**
	 * 3 bytes
	 * #### Bit 0..19
	 * 2 bits Short Id
	 * 2 bits Stream Id
	 * 2 bits audio coding
	 * 1 bit  SBR flag
	 * 2 bits audio mode
	 * 3 bits audio sampling rate
	 * 1 bit  text flag
	 * 1 bit  enhancement flag
	 * 5 bits coder field
	 * 1 bit  rfa
	 * Bit 20..23 r.f.u
	 */
	unsigned int AudioConfig;
	/**
	 * Byte
	 * Bit 0..1 Protection level for part A
	 * Bit 2..3 Protection level for part B
	 * Bit 4..7 r.f.u
	 */
	unsigned char ProtectionLevels;
	/**
	 * Signed long word
	 * -1 = 0xffffffff: BER not available
	 * 0..999999: BER value
	 */
	signed int MSC_BER;
	/**
	 * Byte - Number of CRC fails in the latest audio superframe
	 */
	unsigned char AudioCRCFails;
	/**
	 * Byte
	 * #### Bit 0
	 * 0 audio stream decoder demuted
	 * 1 audio stream decoder muted
	 * Bit 1..7 r.f.u
	 */
	unsigned char AudioMute;
	/**
	 * Byte 0..100 
	 */
	unsigned char ServiceQuality;
	/**
	 * Word
	 * Number of Channel Bit Errors estimated while decoding the FAC
	 */
	unsigned short FAC_ERRS;
	/**
	 * Byte - Number of CRC fails in the decoded FAC
	 */
	unsigned char FAC_CRC_Fails;
	/**
	 * Word
	 * Number of Channel Bit Errors estimated while decoding the SDC
	 */
	unsigned short SDC_ERRS;
	/**
	 * Byte - Number of CRC fails in the decoded SDC
	 */
	unsigned char SDC_CRC_Fails;
	

	clCMDrmTestModeStatus();
	virtual ~clCMDrmTestModeStatus();
	/**
	 * serialize the payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	void ConstructService(tunerVector<unsigned char> bitStream, unsigned short &position);
	void Construct_FAC_SDC(tunerVector<unsigned char> bitStream, unsigned short &position);
	void ConstructServiceLabelData(tunerVector<unsigned char> bitStream, unsigned short &position);
	/**
	 * Read DrmTestModeStatus parameters
	 */

};
#endif // !defined(EA_F607A53F_07DD_49d8_93AD_790C535F949A__INCLUDED_)
