///////////////////////////////////////////////////////////
//  clCMDemodulationSwitchStatus.h
//  Implementation of the Class clCMDemodulationSwitchStatus
//  Created on:      26-Feb-2015 2:29:10 PM
///////////////////////////////////////////////////////////

#if !defined(EA_5FCA27D7_551D_44d7_AE06_1F26586F94BF__INCLUDED_)
#define EA_5FCA27D7_551D_44d7_AE06_1F26586F94BF__INCLUDED_

#include "clADRMsgPayload.h"

class clCMDemodulationSwitchStatus : public clADRMsgPayload
{

public:
	/**
	 * Constructor
	 */
	clCMDemodulationSwitchStatus();
	/**
	 * Destructor
	 */
	virtual ~clCMDemodulationSwitchStatus();
	/**
	 * Boolean (1 Byte)
	 * Bit 0 True FM and AM switch enabled
	 *      False FM and AM switch disabled
	 * Bit 1 True FM-HD switch enabled
	 *      False FM-HD switch disabled
	 * Bit 2 True AM-HD switch enabled
	 *      False AM-HD switch disabled
	 * Bit 3 True DRM30 disabled
	 *      False DRM30 enabled
	 * (4..7 reserved) reserved
	 */
	unsigned char DemodulationSwitches;
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * Set demodulation switch
	 */
	void setDemodulationSwitch(unsigned char newDemodulationSwitch);
	/**
	 * Read Demodulation switch
	 */
	unsigned char getDemodulationSwitch() const;
};
#endif // !defined(EA_5FCA27D7_551D_44d7_AE06_1F26586F94BE__INCLUDED_)
