///////////////////////////////////////////////////////////
//  clCMDateAndTimeStatus.h
//  Implementation of the Class clCMDateAndTimeStatus
//  Created on:      29-May-2015 3:53:02 PM
///////////////////////////////////////////////////////////

#if !defined(EA_79A8F6DD_A926_4de8_B7C0_F9B281EA665F__INCLUDED_)
#define EA_79A8F6DD_A926_4de8_B7C0_F9B281EA665F__INCLUDED_

#include "clADRMsgPayload.h"

class clCMDateAndTimeStatus : public clADRMsgPayload
{

public:
	/**
	 * Unsigned word 2011..65535
	 */
	unsigned short Year;
	/**
	 * Unsigned byte 1..12
	 */
	unsigned char Month;
	/**
	 * Unsigned byte 1..31
	 */
	unsigned char Day;
	/**
	 * Unsigned byte 0..23
	 */
	unsigned char Hour;
	/**
	 * Unsigned byte 0..59
	 */
	unsigned char Minute;

	clCMDateAndTimeStatus();
	virtual ~clCMDateAndTimeStatus();
	/**
	 * serialize the data stream
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the data stream
	 */
	short u16GetSize();
	/**
	 * construct the data stream
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * set DateAndTimeStatus parameters
	 */
	void setYear(unsigned short newYear);
	void setMonth(unsigned char newMonth);
	void setDay(unsigned char newDay);
	void setHour(unsigned char newHour);
	void setMinute(unsigned char newMinute);
	/**
	 * read DateAndTimeStatus parameters
	 */
	unsigned short getYear();
	unsigned char getMonth();
	unsigned char getDay();
	unsigned char getHour();
	unsigned char getMinute();

};
#endif // !defined(EA_79A8F6DD_A926_4de8_B7C0_F9B281EA665F__INCLUDED_)
