///////////////////////////////////////////////////////////
//  clCMDRMAudioStreamDecoderStatusSet.h
//  Implementation of the Class clCMDRMAudioStreamDecoderStatusSet
//  Created on:      10-Jun-2015 1:36:24 PM
///////////////////////////////////////////////////////////

#if !defined(EA_5F5A4517_1ECA_4f2d_91E7_9D3E6E276D15__INCLUDED_)
#define EA_5F5A4517_1ECA_4f2d_91E7_9D3E6E276D15__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMEnumTypes.h"

class clCMDRMAudioStreamDecoderStatusSet : public clADRMsgPayload
{

public:
	/**
	 * Enumeration 0..3
	 * 
	 */
	clCMEnum_AudioStreamType AudioStreamType;
	/**
	 * Unsigned long word 0...0xffffffff
	 */
	unsigned int FrameCntr;
	/**
	 * Enumeration 0..1
	 * 
	 */
	clCMEnum_NonReliabilityIndication NonReliabilityIndication;
	/**
	 * Bit field (3 bytes)
	 */
	tunerVector<unsigned char> AudioInfoEntityShort;
	/**
	 * Enumeration 0..3
	 * 
	 */
	clCMEnum_MuteStatus MuteStatus;
	/**
	 * Unsigned byte 0..255
	 */
	unsigned char SuperFrameCRCFailCounter;
	/**
	 * Unsigned byte 0..255
	 */
	unsigned char AudioFrameCRCFailCounter;
	/**
	 * Unsigned byte 0..255
	 */
	unsigned char RfuByte_0;
	unsigned char RfuByte_1;
	unsigned char RfuByte_2;
	unsigned char RfuByte_3;
	unsigned char RfuByte_4;
	unsigned char RfuByte_5;
	unsigned char RfuByte_6;
	unsigned char RfuByte_7;
	unsigned char RfuByte_8;
	unsigned char RfuByte_9;
	unsigned char RfuByte_10;
	unsigned char RfuByte_11;
	unsigned char RfuByte_12;
	unsigned char RfuByte_13;
	unsigned char RfuByte_14;
	unsigned char RfuByte_15;
	unsigned char RfuByte_16;
	unsigned char RfuByte_17;
	unsigned char RfuByte_18;
	unsigned char RfuByte_19;

	clCMDRMAudioStreamDecoderStatusSet();
	virtual ~clCMDRMAudioStreamDecoderStatusSet();
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * Set DRMAudioStreamDecoderStatusSet parameters
	 */
	void setAudioStreamType(clCMEnum_AudioStreamType::enAudioStreamType newAudioStreamType);
	void setFrameCntr(unsigned int newFrameCntr);
	void setNonReliabilityIndication(clCMEnum_NonReliabilityIndication::enNonReliabilityIndication newNonReliabilityIndication);
	void setAudioInfoEntityShort(tunerVector<unsigned char> newAudioInfoEntityShort);
	void setMuteStatus(clCMEnum_MuteStatus::enMuteStatus newMuteStatus);
	void setSuperFrameCRCFailCounter(unsigned char newSuperFrameCRCFailCounter);
	void setAudioFrameCRCFailCounter(unsigned char newAudioFrameCRCFailCounter);
	void setRfuByte_0(unsigned char newRfuByte_0);
	void setRfuByte_1(unsigned char newRfuByte_1);
	void setRfuByte_2(unsigned char newRfuByte_2);
	void setRfuByte_3(unsigned char newRfuByte_3);
	void setRfuByte_4(unsigned char newRfuByte_4);
	void setRfuByte_5(unsigned char newRfuByte_5);
	void setRfuByte_6(unsigned char newRfuByte_6);
	void setRfuByte_7(unsigned char newRfuByte_7);
	void setRfuByte_8(unsigned char newRfuByte_8);
	void setRfuByte_9(unsigned char newRfuByte_9);
	void setRfuByte_10(unsigned char newRfuByte_10);
	void setRfuByte_11(unsigned char newRfuByte_11);
	void setRfuByte_12(unsigned char newRfuByte_12);
	void setRfuByte_13(unsigned char newRfuByte_13);
	void setRfuByte_14(unsigned char newRfuByte_14);
	void setRfuByte_15(unsigned char newRfuByte_15);
	void setRfuByte_16(unsigned char newRfuByte_16);
	void setRfuByte_17(unsigned char newRfuByte_17);
	void setRfuByte_18(unsigned char newRfuByte_18);
	void setRfuByte_19(unsigned char newRfuByte_19);

};
#endif // !defined(EA_5F5A4517_1ECA_4f2d_91E7_9D3E6E276D15__INCLUDED_)
