///////////////////////////////////////////////////////////
//  clCMDRMAudioStreamDecoderStatusSet.cpp
//  Implementation of the Class clCMDRMAudioStreamDecoderStatusSet
//  Created on:      10-Jun-2015 1:36:24 PM
///////////////////////////////////////////////////////////

#include "clCMDRMAudioStreamDecoderStatusSet.h"

#define NRFUBYTES 20
#define AUDIOINFOENTITYSHORT_LENGTH 3

clCMDRMAudioStreamDecoderStatusSet::clCMDRMAudioStreamDecoderStatusSet()
: FrameCntr(0),
  SuperFrameCRCFailCounter(0),
  AudioFrameCRCFailCounter(0),
  RfuByte_0(0),
  RfuByte_1(0),
  RfuByte_2(0),
  RfuByte_3(0),
  RfuByte_4(0),
  RfuByte_5(0),
  RfuByte_6(0),
  RfuByte_7(0),
  RfuByte_8(0),
  RfuByte_9(0),
  RfuByte_10(0),
  RfuByte_11(0),
  RfuByte_12(0),
  RfuByte_13(0),
  RfuByte_14(0),
  RfuByte_15(0),
  RfuByte_16(0),
  RfuByte_17(0),
  RfuByte_18(0),
  RfuByte_19(0)
{
	AudioInfoEntityShort.push_back(0);
	AudioInfoEntityShort.push_back(0);
	AudioInfoEntityShort.push_back(0);
}

clCMDRMAudioStreamDecoderStatusSet::~clCMDRMAudioStreamDecoderStatusSet(){

}

tunerVector<unsigned char> clCMDRMAudioStreamDecoderStatusSet::oSerialize(){

	tunerVector<unsigned char> payload;

	payload.push_back(static_cast<unsigned char>(AudioStreamType.enType));
	vAddInt(payload, FrameCntr);
	payload.push_back(static_cast<unsigned char>(NonReliabilityIndication.enType));
	payload.insert(payload.end(), AudioInfoEntityShort.begin(), AudioInfoEntityShort.end());
	payload.push_back(static_cast<unsigned char>(MuteStatus.enType));
	payload.push_back(SuperFrameCRCFailCounter);
	payload.push_back(AudioFrameCRCFailCounter);
	payload.push_back(RfuByte_0);
	payload.push_back(RfuByte_1);
	payload.push_back(RfuByte_2);
	payload.push_back(RfuByte_3);
	payload.push_back(RfuByte_4);
	payload.push_back(RfuByte_5);
	payload.push_back(RfuByte_6);
	payload.push_back(RfuByte_7);
	payload.push_back(RfuByte_8);
	payload.push_back(RfuByte_9);
	payload.push_back(RfuByte_10);
	payload.push_back(RfuByte_11);
	payload.push_back(RfuByte_12);
	payload.push_back(RfuByte_13);
	payload.push_back(RfuByte_14);
	payload.push_back(RfuByte_15);
	payload.push_back(RfuByte_16);
	payload.push_back(RfuByte_17);
	payload.push_back(RfuByte_18);
	payload.push_back(RfuByte_19);

	return payload;
}

short clCMDRMAudioStreamDecoderStatusSet::u16GetSize(){

	short size = 0;

	size =(short)(size + AudioStreamType.getSize() + NonReliabilityIndication.getSize() + MuteStatus.getSize());
	size =(short)(size + AUDIOINFOENTITYSHORT_LENGTH);
	size =(short)(size + sizeof(FrameCntr) + sizeof(SuperFrameCRCFailCounter) + sizeof(AudioFrameCRCFailCounter) + (sizeof(RfuByte_0) * NRFUBYTES));

	return size;
}

void clCMDRMAudioStreamDecoderStatusSet::vConstruct(tunerVector<unsigned char> /*bitStream*/){

}

void clCMDRMAudioStreamDecoderStatusSet::setAudioStreamType(clCMEnum_AudioStreamType::enAudioStreamType newAudioStreamType)
{
	AudioStreamType.enType = newAudioStreamType;
}

void clCMDRMAudioStreamDecoderStatusSet::setFrameCntr(unsigned int newFrameCntr)
{
	FrameCntr = newFrameCntr;
}

void clCMDRMAudioStreamDecoderStatusSet::setNonReliabilityIndication(clCMEnum_NonReliabilityIndication::enNonReliabilityIndication newNonReliabilityIndication)
{
	NonReliabilityIndication.enType = newNonReliabilityIndication;
}

void clCMDRMAudioStreamDecoderStatusSet::setAudioInfoEntityShort(tunerVector<unsigned char> newAudioInfoEntityShort)
{
	AudioInfoEntityShort.assign(newAudioInfoEntityShort.begin(), newAudioInfoEntityShort.end());
}

void clCMDRMAudioStreamDecoderStatusSet::setMuteStatus(clCMEnum_MuteStatus::enMuteStatus newMuteStatus)
{
	MuteStatus.enType = newMuteStatus;
}

void clCMDRMAudioStreamDecoderStatusSet::setSuperFrameCRCFailCounter(unsigned char newSuperFrameCRCFailCounter)
{
	SuperFrameCRCFailCounter = newSuperFrameCRCFailCounter;
}

void clCMDRMAudioStreamDecoderStatusSet::setAudioFrameCRCFailCounter(unsigned char newAudioFrameCRCFailCounter)
{
	AudioFrameCRCFailCounter = newAudioFrameCRCFailCounter;
}

void clCMDRMAudioStreamDecoderStatusSet::setRfuByte_0(unsigned char newRfuByte_0)
{
	RfuByte_0 = newRfuByte_0;
}

void clCMDRMAudioStreamDecoderStatusSet::setRfuByte_1(unsigned char newRfuByte_1)
{
	RfuByte_1 = newRfuByte_1;
}

void clCMDRMAudioStreamDecoderStatusSet::setRfuByte_2(unsigned char newRfuByte_2)
{
	RfuByte_2 = newRfuByte_2;
}

void clCMDRMAudioStreamDecoderStatusSet::setRfuByte_3(unsigned char newRfuByte_3)
{
	RfuByte_3 = newRfuByte_3;
}

void clCMDRMAudioStreamDecoderStatusSet::setRfuByte_4(unsigned char newRfuByte_4)
{
	RfuByte_4 = newRfuByte_4;
}

void clCMDRMAudioStreamDecoderStatusSet::setRfuByte_5(unsigned char newRfuByte_5)
{
	RfuByte_5 = newRfuByte_5;
}

void clCMDRMAudioStreamDecoderStatusSet::setRfuByte_6(unsigned char newRfuByte_6)
{
	RfuByte_6 = newRfuByte_6;
}

void clCMDRMAudioStreamDecoderStatusSet::setRfuByte_7(unsigned char newRfuByte_7)
{
	RfuByte_7 = newRfuByte_7;
}

void clCMDRMAudioStreamDecoderStatusSet::setRfuByte_8(unsigned char newRfuByte_8)
{
	RfuByte_8 = newRfuByte_8;
}

void clCMDRMAudioStreamDecoderStatusSet::setRfuByte_9(unsigned char newRfuByte_9)
{
	RfuByte_9 = newRfuByte_9;
}

void clCMDRMAudioStreamDecoderStatusSet::setRfuByte_10(unsigned char newRfuByte_10)
{
	RfuByte_10 = newRfuByte_10;
}

void clCMDRMAudioStreamDecoderStatusSet::setRfuByte_11(unsigned char newRfuByte_11)
{
	RfuByte_11 = newRfuByte_11;
}

void clCMDRMAudioStreamDecoderStatusSet::setRfuByte_12(unsigned char newRfuByte_12)
{
	RfuByte_12 = newRfuByte_12;
}

void clCMDRMAudioStreamDecoderStatusSet::setRfuByte_13(unsigned char newRfuByte_13)
{
	RfuByte_13 = newRfuByte_13;
}

void clCMDRMAudioStreamDecoderStatusSet::setRfuByte_14(unsigned char newRfuByte_14)
{
	RfuByte_14 = newRfuByte_14;
}

void clCMDRMAudioStreamDecoderStatusSet::setRfuByte_15(unsigned char newRfuByte_15)
{
	RfuByte_15 = newRfuByte_15;
}

void clCMDRMAudioStreamDecoderStatusSet::setRfuByte_16(unsigned char newRfuByte_16)
{
	RfuByte_16 = newRfuByte_16;
}

void clCMDRMAudioStreamDecoderStatusSet::setRfuByte_17(unsigned char newRfuByte_17)
{
	RfuByte_17 = newRfuByte_17;
}

void clCMDRMAudioStreamDecoderStatusSet::setRfuByte_18(unsigned char newRfuByte_18)
{
	RfuByte_18 = newRfuByte_18;
}

void clCMDRMAudioStreamDecoderStatusSet::setRfuByte_19(unsigned char newRfuByte_19)
{
	RfuByte_19 = newRfuByte_19;
}
