///////////////////////////////////////////////////////////
//  clCMDRMAudioLogicalFrameStatus.cpp
//  Implementation of the Class clCMDRMAudioLogicalFrameStatus
//  Created on:      14-Jan-2015 15:55:41
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#include "clCMDRMAudioLogicalFrameStatus.h"
#include "datatypes/tAlgorithm.h"
#include "datatypes/tString.h"

#define AUDIOINFOENTITY_MINSIZE 3
#define TEXTMSGLENGTH           4
#define AUDIOINFO_SECONDBYTE    1
#define TEXTFLAG_BIT_MASK       0x08
#define SHIFT_3BITS             3

clCMDRMAudioLogicalFrameStatus::clCMDRMAudioLogicalFrameStatus() : FrameCntr(0),
LenAudioInfoEntity(0),
RfuByte_0(0),
RfuByte_1(0),
RfuByte_2(0),
RfuByte_3(0),
RfuByte_4(0),
RfuByte_5(0),
RfuByte_6(0),
RfuByte_7(0),
RfuByte_8(0),
RfuByte_9(0),
RfuByte_10(0),
RfuByte_11(0),
RfuByte_12(0),
RfuByte_13(0),
RfuByte_14(0),
RfuByte_15(0),
RfuByte_16(0),
RfuByte_17(0),
LenHigherProtFrameData(0),
LenFrameData(0)
{

}

clCMDRMAudioLogicalFrameStatus::~clCMDRMAudioLogicalFrameStatus(){

}

tunerVector<unsigned char> clCMDRMAudioLogicalFrameStatus::oSerialize(){

	tunerVector<unsigned char> payload;
	return payload;
}

short clCMDRMAudioLogicalFrameStatus::u16GetSize(){

	return 0;
}

void clCMDRMAudioLogicalFrameStatus::vConstruct(tunerVector<unsigned char> bitStream){

	unsigned short position = 0;
	unsigned char MSB = 0;
	unsigned char LSB = 0;

	AudioStreamType.enType = static_cast<clCMEnum_AudioStreamType::enAudioStreamType>(bitStream[position++]);

	Action.enType = static_cast<clCMEnum_Action::enAction>(bitStream[position++]);

	FrameCntr = getInt(bitStream, position);
	position =(unsigned short)(position + sizeof(FrameCntr));

	NonReliabilityIndication.enType = static_cast<clCMEnum_NonReliabilityIndication::enNonReliabilityIndication>(bitStream[position++]);

	LenAudioInfoEntity = bitStream[position++];

    tunerVector<unsigned char>::iterator start = bitStream.begin() + position;
    tunerVector<unsigned char>::iterator end = bitStream.begin() + position + LenAudioInfoEntity;
    AudioInfoEntity.insert(AudioInfoEntity.end(), start, end);

    position =(unsigned short)(position + LenAudioInfoEntity);

    vConstructRFUBytes(bitStream, position);

	MSB = bitStream[position++];
	LSB = bitStream[position++];
	LenHigherProtFrameData = getWord(LSB, MSB);

	MSB = bitStream[position++];
	LSB = bitStream[position++];
	LenFrameData = getWord(LSB, MSB);

    /*text messages added in Frame Data are being discarded
	* start
	*/
	CalculateFrameDataLength();
	/* end */

    start = bitStream.begin() + position;
    end = bitStream.begin() + position + LenFrameData;
    FrameData.insert(FrameData.end(), start, end);
	position =(unsigned short)(position + LenFrameData);

}

void clCMDRMAudioLogicalFrameStatus::CalculateFrameDataLength()
{
	if(AudioInfoEntity.size() >= AUDIOINFOENTITY_MINSIZE)
	{
		unsigned char AudioInfoSecondByte  =  AudioInfoEntity[AUDIOINFO_SECONDBYTE];
	    unsigned char textflag = (AudioInfoSecondByte & TEXTFLAG_BIT_MASK) >> SHIFT_3BITS;
	    if(textflag)
	    {
	    	if((int)LenFrameData >= TEXTMSGLENGTH)
	    	{
	    		LenFrameData =(unsigned short)(LenFrameData - TEXTMSGLENGTH);
	    	}
	    }
	}
}

void clCMDRMAudioLogicalFrameStatus::vConstructRFUBytes(tunerVector<unsigned char> bitStream, unsigned short &position)
{
	RfuByte_0 = bitStream[position++];
	RfuByte_1 = bitStream[position++];
	RfuByte_2 = bitStream[position++];
	RfuByte_3 = bitStream[position++];
	RfuByte_4 = bitStream[position++];
	RfuByte_5 = bitStream[position++];
	RfuByte_6 = bitStream[position++];
	RfuByte_7 = bitStream[position++];
	RfuByte_8 = bitStream[position++];
	RfuByte_9 = bitStream[position++];
	RfuByte_10 = bitStream[position++];
	RfuByte_11 = bitStream[position++];
	RfuByte_12 = bitStream[position++];
	RfuByte_13 = bitStream[position++];
	RfuByte_14 = bitStream[position++];
	RfuByte_15 = bitStream[position++];
	RfuByte_16 = bitStream[position++];
	RfuByte_17 = bitStream[position++];
}

void clCMDRMAudioLogicalFrameStatus::setAudioInfoEntity(tunerVector<unsigned char> newAudioInfoEntity)
{
	AudioInfoEntity.assign(newAudioInfoEntity.begin(), newAudioInfoEntity.end());
}

void clCMDRMAudioLogicalFrameStatus::setFrameData(tunerVector<unsigned char> newFrameData)
{
	FrameData.assign(newFrameData.begin(), newFrameData.end());
}

clCMEnum_AudioStreamType::enAudioStreamType clCMDRMAudioLogicalFrameStatus::getAudioStreamType()
{
	return AudioStreamType.enType;
}

clCMEnum_Action::enAction clCMDRMAudioLogicalFrameStatus::getAction()
{
	return Action.enType;
}

unsigned int clCMDRMAudioLogicalFrameStatus::getFrameCntr()
{
	return FrameCntr;
}

clCMEnum_NonReliabilityIndication::enNonReliabilityIndication clCMDRMAudioLogicalFrameStatus::getNonReliabilityIndication()
{
	return NonReliabilityIndication.enType;
}

unsigned char clCMDRMAudioLogicalFrameStatus::getLenAudioInfoEntity()
{
	return LenAudioInfoEntity;
}

tunerVector<unsigned char> clCMDRMAudioLogicalFrameStatus::getAudioInfoEntity()
{
	return AudioInfoEntity;
}

unsigned char clCMDRMAudioLogicalFrameStatus::getRfuByte_0()
{
	return RfuByte_0;
}

unsigned char clCMDRMAudioLogicalFrameStatus::getRfuByte_1()
{
	return RfuByte_1;
}

unsigned char clCMDRMAudioLogicalFrameStatus::getRfuByte_2()
{
	return RfuByte_2;
}

unsigned char clCMDRMAudioLogicalFrameStatus::getRfuByte_3()
{
	return RfuByte_3;
}

unsigned char clCMDRMAudioLogicalFrameStatus::getRfuByte_4()
{
	return RfuByte_4;
}

unsigned char clCMDRMAudioLogicalFrameStatus::getRfuByte_5()
{
	return RfuByte_5;
}

unsigned char clCMDRMAudioLogicalFrameStatus::getRfuByte_6()
{
	return RfuByte_6;
}

unsigned char clCMDRMAudioLogicalFrameStatus::getRfuByte_7()
{
	return RfuByte_7;
}

unsigned char clCMDRMAudioLogicalFrameStatus::getRfuByte_8()
{
	return RfuByte_8;
}

unsigned char clCMDRMAudioLogicalFrameStatus::getRfuByte_9()
{
	return RfuByte_9;
}

unsigned char clCMDRMAudioLogicalFrameStatus::getRfuByte_10()
{
	return RfuByte_10;
}

unsigned char clCMDRMAudioLogicalFrameStatus::getRfuByte_11()
{
	return RfuByte_11;
}

unsigned char clCMDRMAudioLogicalFrameStatus::getRfuByte_12()
{
	return RfuByte_12;
}

unsigned char clCMDRMAudioLogicalFrameStatus::getRfuByte_13()
{
	return RfuByte_13;
}

unsigned char clCMDRMAudioLogicalFrameStatus::getRfuByte_14()
{
	return RfuByte_14;
}

unsigned char clCMDRMAudioLogicalFrameStatus::getRfuByte_15()
{
	return RfuByte_15;
}

unsigned char clCMDRMAudioLogicalFrameStatus::getRfuByte_16()
{
	return RfuByte_16;
}

unsigned char clCMDRMAudioLogicalFrameStatus::getRfuByte_17()
{
	return RfuByte_17;
}

unsigned short clCMDRMAudioLogicalFrameStatus::getLenHigherProtFrameData()
{
	return LenHigherProtFrameData;
}

unsigned short clCMDRMAudioLogicalFrameStatus::getLenFrameData()
{
	return LenFrameData;
}

tunerVector<unsigned char> clCMDRMAudioLogicalFrameStatus::getFrameData()
{
	return FrameData;
}
