///////////////////////////////////////////////////////////
//  clCMAutostore.cpp
//  Implementation of the Class clCMAutostore
//  Created on:      14-Jan-2015 10:12:19 AM
//  Original author: pmn3kor
///////////////////////////////////////////////////////////

#include "clCMAutostore.h"
#include "datatypes/tAlgorithm.h"

clCMAutostore::clCMAutostore(){
	u16FunctionIdOfList = 0;
	u8BehaviouralSwitches = 0;
	u8MaxNumberOfStations = 0;
	u8SortingCriteria = 0;
	u8UnusedPresetTreatment = 0;
}



clCMAutostore::~clCMAutostore(){

}





/**
 * Get function ID of Preset list
 */
unsigned short clCMAutostore::Getu16FunctionIdOfList(){

    return u16FunctionIdOfList;
}


/**
 * get u8BehaviouralSwitches value
 */
unsigned char clCMAutostore::Getu8BehaviouralSwitches(){

	return u8BehaviouralSwitches;
}


/**
 * get MaxNumberofStations value
 */
unsigned char clCMAutostore::Getu8MaxNumberOfStations(){

	return u8MaxNumberOfStations;
}


unsigned char clCMAutostore::Getu8SortingCriteria(){

	return u8SortingCriteria;
}


unsigned char clCMAutostore::Getu8UnusedPresetTreatment(){

    return u8UnusedPresetTreatment;
}


/**
 * set u16FunctionIdOfList value
 */
void clCMAutostore::Setu16FunctionIdOfList(unsigned short newVal){

    u16FunctionIdOfList = newVal;
}


void clCMAutostore::Setu8BehaviouralSwitches(unsigned char newVal){

	u8BehaviouralSwitches = newVal;
}


void clCMAutostore::Setu8MaxNumberOfStations(unsigned char newVal){

	u8MaxNumberOfStations = newVal;
}


void clCMAutostore::Setu8SortingCriteria(unsigned char newVal){

	u8SortingCriteria = newVal;
}


void clCMAutostore::Setu8UnusedPresetTreatment(unsigned char newVal){

    u8UnusedPresetTreatment = newVal;
}


/**
 * returns the size of the payload
 */
short clCMAutostore::u16GetSize(){

    return (sizeof(u16FunctionIdOfList) + sizeof(u8BehaviouralSwitches) + sizeof(u8MaxNumberOfStations) + sizeof(u8SortingCriteria) + sizeof(u8UnusedPresetTreatment));
}


/**
 * get the payload of autostore function
 */
void clCMAutostore::vConstruct(tunerVector<unsigned char> bitStream){

   short index = 0;
   unsigned char MSB = bitStream[index++];
   unsigned char LSB = bitStream[index++];
   u16FunctionIdOfList = getWord(LSB, MSB);
   u8MaxNumberOfStations = bitStream[index++];
   u8UnusedPresetTreatment = bitStream[index++];
   u8SortingCriteria = bitStream[index++];
   u8BehaviouralSwitches = bitStream[index++];
}

tunerVector<unsigned char> clCMAutostore::oSerialize()
{
    tunerVector<unsigned char> payloadData;
    payloadData.push_back(getMSB(u16FunctionIdOfList));
    payloadData.push_back(getLSB(u16FunctionIdOfList));
    payloadData.push_back(u8MaxNumberOfStations);
    payloadData.push_back(u8UnusedPresetTreatment);
    payloadData.push_back(u8SortingCriteria);
    payloadData.push_back(u8BehaviouralSwitches);
    return payloadData;
}
