///////////////////////////////////////////////////////////
//  clCMAtSeek.h
//  Implementation of the Class clCMAtSeek
//  Created on:      12-Jan-2015 14:47:42
//  Original author: pad1cob
///////////////////////////////////////////////////////////
#ifndef clCMAtSeek_h
#define clCMAtSeek_h

#include "clADRMsgPayload.h"
#include "datatypes/tVector.h"

/**
 * Class used to contain information related to the Seek function
 * @author pad1cob
 * @version 1.0
 * @created 12-Jan-2015 14:47:42
 */
class clCMAtSeek : public clADRMsgPayload
{

public:
	clCMAtSeek();
	virtual ~clCMAtSeek();

	char getu8SeekMode();
	long getu32Frequency();
	/**
	 * returns the size of the data stream
	 */
	virtual tunerVector<unsigned char> oSerialize();
	/**
	 * 
	 * @param newVal
	 */
	void setu8SeekMode(char newVal);
	/**
	 * 
	 * @param newVal
	 */
	void setu32Frequency(long newVal);
	/**
	 * returns the size of the payload
	 */
	virtual short u16GetSize();
	/**
	 * 
	 * @param bitStream
	 */
	virtual void vConstruct(tunerVector<unsigned char> bitStream);

private:
	/**
	 * The u8SeekMode as defined in ADR spec
	 */
	char u8SeekMode;
	/**
	 * The u32Frequency range as defined in ADR spec
	 */
	long u32Frequency;

};
#endif
