///////////////////////////////////////////////////////////
//  clCMAnnouncementSwitchSetGet.cpp
//  Implementation of the Class clCMAnnouncementSwitchSetGet
//  Created on:      27-May-2015 5:02:02 PM
///////////////////////////////////////////////////////////

#include "clCMAnnouncementSwitchSetGet.h"

#define TPON     0x01
#define TPOFF    0xFE
#define PTY31ON  0x02
#define PTY31OFF 0xFD

clCMAnnouncementSwitchSetGet::clCMAnnouncementSwitchSetGet() : Announcements(0){

}

clCMAnnouncementSwitchSetGet::~clCMAnnouncementSwitchSetGet(){

}

tunerVector<unsigned char> clCMAnnouncementSwitchSetGet::oSerialize(){

	tunerVector<unsigned char> payload;
	payload.push_back(Announcements);
	return payload;
}

short clCMAnnouncementSwitchSetGet::u16GetSize(){

	return sizeof(Announcements);
}

void clCMAnnouncementSwitchSetGet::vConstruct(tunerVector<unsigned char> /*bitStream*/){

}

void clCMAnnouncementSwitchSetGet::setAnnouncements(unsigned char newAnnouncements){

	Announcements = newAnnouncements;
}

void clCMAnnouncementSwitchSetGet::setTPOn()
{
	Announcements |= TPON;
}

void clCMAnnouncementSwitchSetGet::setTPOff()
{
	Announcements &= TPOFF;
}

void clCMAnnouncementSwitchSetGet::setPTY31On()
{
	Announcements |= PTY31ON;
}

void clCMAnnouncementSwitchSetGet::setPTY31Off()
{
	Announcements &= PTY31OFF;
}
