///////////////////////////////////////////////////////////
//  clCMAnnouncementSwitchSet.cpp
//  Implementation of the Class clCMAnnouncementSwitchSet
//  Created on:      27-May-2015 4:44:07 PM
///////////////////////////////////////////////////////////

#include "clCMAnnouncementSwitchSet.h"

#define TPON     0x01
#define TPOFF    0xFE
#define PTY31ON  0x02
#define PTY31OFF 0xFD

clCMAnnouncementSwitchSet::clCMAnnouncementSwitchSet() : Announcements(0){

}

clCMAnnouncementSwitchSet::~clCMAnnouncementSwitchSet(){

}

tunerVector<unsigned char> clCMAnnouncementSwitchSet::oSerialize(){

	tunerVector<unsigned char> payload;
	payload.push_back(Announcements);
	return payload;
}

short clCMAnnouncementSwitchSet::u16GetSize(){

	return sizeof(Announcements);
}

void clCMAnnouncementSwitchSet::vConstruct(tunerVector<unsigned char> /*bitStream*/){

}

void clCMAnnouncementSwitchSet::setAnnouncements(unsigned char newAnnouncements)
{
	Announcements = newAnnouncements;
}

void clCMAnnouncementSwitchSet::setTPOn()
{
	Announcements |= TPON;
}

void clCMAnnouncementSwitchSet::setTPOff()
{
	Announcements &= TPOFF;
}

void clCMAnnouncementSwitchSet::setPTY31On()
{
	Announcements |= PTY31ON;
}

void clCMAnnouncementSwitchSet::setPTY31Off()
{
	Announcements &= PTY31OFF;
}
