///////////////////////////////////////////////////////////
//  clCMAnnouncementInfoStatus.cpp
//  Implementation of the Class clCMAnnouncementInfoStatus
//  Created on:      28-May-2015 10:13:37 AM
///////////////////////////////////////////////////////////

#include "clCMAnnouncementInfoStatus.h"

#define TASTATIONNAME_LENGTH 8

clCMAnnouncementInfoStatus::clCMAnnouncementInfoStatus() : Frequency(0),
PI(0){

}

clCMAnnouncementInfoStatus::~clCMAnnouncementInfoStatus(){

}

tunerVector<unsigned char> clCMAnnouncementInfoStatus::oSerialize(){

	tunerVector<unsigned char> payload;
	return payload;
}

short clCMAnnouncementInfoStatus::u16GetSize(){

	return 0;
}

void clCMAnnouncementInfoStatus::vConstruct(tunerVector<unsigned char> bitStream){

	short position = 0;

	Frequency = getInt(bitStream, position);
	position =(short)(position + sizeof(Frequency));

	unsigned char MSB = bitStream[position++];
	unsigned char LSB = bitStream[position++];
	PI = getWord(LSB, MSB);

	tunerString oString((const char *)&(bitStream[position]), TASTATIONNAME_LENGTH);
	TaStationname = oString;
	position =(short)(position + TASTATIONNAME_LENGTH);

	AnnouncementType.enType = static_cast<clCMEnum_AnnouncementType::enAnnouncementType>(bitStream[position++]);
}

void clCMAnnouncementInfoStatus::setFrequency(unsigned int newFrequency)
{
	Frequency = newFrequency;
}

void clCMAnnouncementInfoStatus::setPI(unsigned short newPI)
{
	PI = newPI;
}

void clCMAnnouncementInfoStatus::setTaStationname(tunerString newTaStationname)
{
	short StringSize = (short)newTaStationname.size();
	if(StringSize > TASTATIONNAME_LENGTH)
	{
		StringSize = TASTATIONNAME_LENGTH;
	}
	tunerString oString(newTaStationname.c_str(), StringSize);
	TaStationname = oString;
}

void clCMAnnouncementInfoStatus::setAnnouncementType(clCMEnum_AnnouncementType::enAnnouncementType newAnnouncementType)
{
	AnnouncementType.enType = newAnnouncementType;
}

unsigned int clCMAnnouncementInfoStatus::getFrequency()
{
	return Frequency;
}

unsigned short clCMAnnouncementInfoStatus::getPI()
{
	return PI;
}

const char * clCMAnnouncementInfoStatus::getTaStationname()
{
	return TaStationname.c_str();
}

clCMEnum_AnnouncementType::enAnnouncementType clCMAnnouncementInfoStatus::getAnnouncementType()
{
	return AnnouncementType.enType;
}
