///////////////////////////////////////////////////////////
//  clCMATStationInfoStatus.h
//  Implementation of the Class clCMATStationInfoStatus
//  Created on:      15-Apr-2015 4:07:39 PM
///////////////////////////////////////////////////////////

#if !defined(EA_324E156A_B53D_4c70_892F_B58A37258DBE__INCLUDED_)
#define EA_324E156A_B53D_4c70_892F_B58A37258DBE__INCLUDED_

#include "clADRMsgPayload.h"
#include "datatypes/tString.h"
#include "types/clCMEnumTypes.h"

class clCMATStationInfoStatus : public clADRMsgPayload
{

public:
	/**
	 * String - 8
	 */
	tunerString RdsStationname;
	/**
	 * Enumeration 0..3
	 * 0 NON-RDS Station
	 * 1 Station name is first received PS
	 * 2 Station name is last received PS
	 * 3 Name assigned by customer
	 */
	clCMEnum_RdsStationnameInfo RdsStationnameInfo;
	/**
	 * Unsigned long 150..108000
	 */
	unsigned int Frequency;
	/**
	 * Unsigned byte 0..31
	 */
	unsigned char PTY;
	/**
	 * Unsigned word 0..0xffff
	 */
	unsigned short PI;
	/**
	 * Enumeration 0..4
	 * 0 TP status of station is unknown
	 * 1 Station is NO-TP station
	 * 2 Station is SELF-TP station
	 * 3 Station is EON-TP station
	 * 4 Station is TP station but TP synchronisation is lost
	 */
	clCMEnum_ATStationTpInfo ATStationTpInfo;
	/**
	 * Enumeration 0..2
	 * 0 TMC status of station is unknown
	 * 1 Station is NO- TMC station
	 * 2 Station is TMC station
	 */
	clCMEnum_ATStationTmcInfo ATStationTmcInfo;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char Fieldstrength;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char Quality;
	/**
	 * Enumeration 0..18 And 0xff
	 */
	clCMEnum_Band Band;
	/**
	 * Unsigned word 0x0f20..0x0f3f
	 */
	unsigned short ActivePresetList;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char ActiveStationList;
	/**
	 * Unsigned word 0..0xffff
	 */
	unsigned short PresetAutocompare;
	/**
	 * Unsigned word 0..0xffff
	 */
	unsigned short StationListAutocompare;
	/**
	 * Boolean(1 byte)
	 */
	unsigned char ATStationInfoBits;
	/**
	 * Boolean(1 byte)
	 */
	unsigned char HDStationInfoBits;
	/**
	 * Unsigned long word 0..0xffffffff
	 */
	unsigned int HDStationId;
	/**
	 * string - 8
	 */
	tunerString HDCallSign;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char HDCallsignTextEncoding;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char HDStationGenre;
	/**
	 * Boolean(1 byte)
	 */
	unsigned char HDNumberOfAudioServices;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char HDQuality;
	/**
	 * Enumeration 0..7
	 * 0     Audio program 1 (MPS)
	 * 1..7 Audio program 2 .. 8 (SPS)
	 */
	clCMEnum_HDActiveAudioProgram HDActiveAudioProgram;
	/**
	 * Boolean(1 byte)
	 */
	unsigned char DRMStationInfoBits;
	/**
	 * Unsigned long word 0..0xffffffff
	 */
	unsigned int DRMServiceId;
	/**
	 * Bytearray 64
	 */
	tunerVector<unsigned char> DRMServiceLabel;
	/**
	 * Unsigned byte 0..31
	 */
	unsigned char DRMPTY;
	/**
	 * Boolean(2 byte) Bit 0..15 (t.b.d)
	 */
	unsigned short DRMAnnoSupport;
	/**
	 * Boolean(1 byte)
	 */
	unsigned char DRMNumberOfAudioServices;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char DRMQuality;
	/**
	 * Enumeration 0..3
	 * 0 Audio program 1
	 * 3 Audio program 4
	 */
	clCMEnum_DRMServiceShortId DRMServiceShortId;
	/**
	 * unsigned char 0..0xff
	 */
	unsigned char rfu_byte_0;
	unsigned char rfu_byte_1;
	unsigned char rfu_byte_2;
	unsigned char rfu_byte_3;
	unsigned char rfu_byte_4;
	unsigned char rfu_byte_5;
	unsigned char rfu_byte_6;
	unsigned char rfu_byte_7;
	unsigned char rfu_byte_8;
	unsigned char rfu_byte_9;
	unsigned char rfu_byte_10;
	unsigned char rfu_byte_11;

	clCMATStationInfoStatus();
	virtual ~clCMATStationInfoStatus();
	/**
	 * serialize the data stream
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the data stream
	 */
	short u16GetSize();
	/**
	 * constructs the data stream
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	void ConstructHDParams(tunerVector<unsigned char> bitStream, short &pos);
	void ConstructDRMParams(tunerVector<unsigned char> bitStream, short &pos);
	void Constructrfu_bytes(tunerVector<unsigned char> bitStream, short &pos);
	/**
	 * Set ATStationInfoStatus parameters
	 */
	void setRdsStationname(tunerString newRdsStationname);
	void setRdsStationnameInfo(clCMEnum_RdsStationnameInfo::enRdsStationnameInfo newRdsStationnameInfo);
	void setFrequency(unsigned int newFrequency);
	void setPTY(unsigned char newPTY);
	void setPI(unsigned short newPI);
	void setATStationTpInfo(clCMEnum_ATStationTpInfo::enATStationTpInfo newATStationTpInfo);
	void setATStationTmcInfo(clCMEnum_ATStationTmcInfo::enATStationTmcInfo newATStationTmcInfo);
	void setFieldstrength(unsigned char newFieldstrength);
	void setQuality(unsigned char newQuality);
	void setBand(clCMEnum_Band::enBand newBand);
	void setActivePresetList(unsigned short newActivePresetList);
	void setActiveStationList(unsigned char newActiveStationList);
	void setPresetAutocompare(unsigned short newPresetAutocompare);
	void setStationListAutocompare(unsigned short newStationListAutocompare);
	void setATStationInfoBits(unsigned char newATStationInfoBits);
	void setHDStationInfoBits(unsigned char newHDStationInfoBits);
	void setHDStationId(unsigned long newHDStationId);
	void setHDCallSign(tunerString newHDCallSign);
	void setHDCallsignTextEncoding(unsigned char newHDCallsignTextEncoding);
	void setHDStationGenre(unsigned char newHDStationGenre);
	void setHDNumberOfAudioServices(unsigned char newHDNumberOfAudioServices);
	void setHDQuality(unsigned char newHDQuality);
	void setHDActiveAudioProgram(clCMEnum_HDActiveAudioProgram::enHDActiveAudioProgram newHDActiveAudioProgram);
	void setDRMStationInfoBits(unsigned char newDRMStationInfoBits);
	void setDRMServiceId(unsigned long newDRMServiceId);
	void setDRMServiceLabel(tunerVector<unsigned char> newDRMServiceLabel);
	void setDRMPTY(unsigned char newDRMPTY);
	void setDRMAnnoSupport(unsigned short newDRMAnnoSupport);
	void setDRMNumberOfAudioServices(unsigned char newDRMNumberOfAudioServices);
	void setDRMQuality(unsigned char newDRMQuality);
	void setDRMServiceShortId(clCMEnum_DRMServiceShortId::enDRMServiceShortId newDRMServiceShortId);
	void setrfu_byte_0(unsigned char newrfu_byte);
	void setrfu_byte_1(unsigned char newrfu_byte);
	void setrfu_byte_2(unsigned char newrfu_byte);
	void setrfu_byte_3(unsigned char newrfu_byte);
	void setrfu_byte_4(unsigned char newrfu_byte);
	void setrfu_byte_5(unsigned char newrfu_byte);
	void setrfu_byte_6(unsigned char newrfu_byte);
	void setrfu_byte_7(unsigned char newrfu_byte);
	void setrfu_byte_8(unsigned char newrfu_byte);
	void setrfu_byte_9(unsigned char newrfu_byte);
	void setrfu_byte_10(unsigned char newrfu_byte);
	void setrfu_byte_11(unsigned char newrfu_byte);
	/**
	 * Read ATStationInfoStatus parameters
	 */
	const char * getRdsStationname();
	clCMEnum_RdsStationnameInfo::enRdsStationnameInfo getRdsStationnameInfo();
	unsigned int getFrequency();
	unsigned char getPTY();
	unsigned short getPI();
	clCMEnum_ATStationTpInfo::enATStationTpInfo getATStationTpInfo();
	clCMEnum_ATStationTmcInfo::enATStationTmcInfo getATStationTmcInfo();
	unsigned char getFieldstrength();
	unsigned char getQuality();
	clCMEnum_Band::enBand getBand();
	unsigned short getActivePresetList();
	unsigned char getActiveStationList();
	unsigned short getPresetAutocompare();
	unsigned short getStationListAutocompare();
	unsigned char getATStationInfoBits();
	unsigned char getHDStationInfoBits();
	unsigned long getHDStationId();
	const char * getHDCallSign();
	unsigned char getHDCallsignTextEncoding();
	unsigned char getHDStationGenre();
	unsigned char getHDNumberOfAudioServices();
	unsigned char getHDQuality();
	clCMEnum_HDActiveAudioProgram::enHDActiveAudioProgram getHDActiveAudioProgram();
	unsigned char getDRMStationInfoBits();
	unsigned long getDRMServiceId();
	tunerVector<unsigned char> getDRMServiceLabel();
	unsigned char getDRMPTY();
	unsigned short getDRMAnnoSupport();
	unsigned char getDRMNumberOfAudioServices();
	unsigned char getDRMQuality();
	clCMEnum_DRMServiceShortId::enDRMServiceShortId getDRMServiceShortId();
	unsigned char getrfu_byte_0();
	unsigned char getrfu_byte_1();
	unsigned char getrfu_byte_2();
	unsigned char getrfu_byte_3();
	unsigned char getrfu_byte_4();
	unsigned char getrfu_byte_5();
	unsigned char getrfu_byte_6();
	unsigned char getrfu_byte_7();
	unsigned char getrfu_byte_8();
	unsigned char getrfu_byte_9();
	unsigned char getrfu_byte_10();
	unsigned char getrfu_byte_11();
};
#endif // !defined(EA_324E156A_B53D_4c70_892F_B58A37258DBE__INCLUDED_)
