///////////////////////////////////////////////////////////
//  clCMATStationInfoStatus.cpp
//  Implementation of the Class clCMATStationInfoStatus
//  Created on:      15-Apr-2015 4:07:39 PM
///////////////////////////////////////////////////////////

#include "clCMATStationInfoStatus.h"

#define RDSSTATIONNAMELENGTH 8
#define HDCALLSIGNLENGTH     8
#define DRMSERVICELABEL_SIZE 64

clCMATStationInfoStatus::clCMATStationInfoStatus() :
RdsStationname(""),
Frequency(0),
PTY(0),
PI(0),
Fieldstrength(0),
Quality(0),
ActivePresetList(0),
ActiveStationList(0),
PresetAutocompare(0),
StationListAutocompare(0),
ATStationInfoBits(0),
HDStationInfoBits(0),
HDStationId(0),
HDCallSign(""),
HDCallsignTextEncoding(0),
HDStationGenre(0),
HDNumberOfAudioServices(0),
HDQuality(0),
DRMStationInfoBits(0),
DRMServiceId(0),
DRMPTY(0),
DRMAnnoSupport(0),
DRMNumberOfAudioServices(0),
DRMQuality(0),
rfu_byte_0(0),
rfu_byte_1(0),
rfu_byte_2(0),
rfu_byte_3(0),
rfu_byte_4(0),
rfu_byte_5(0),
rfu_byte_6(0),
rfu_byte_7(0),
rfu_byte_8(0),
rfu_byte_9(0),
rfu_byte_10(0),
rfu_byte_11(0){

}

clCMATStationInfoStatus::~clCMATStationInfoStatus(){

}

tunerVector<unsigned char> clCMATStationInfoStatus::oSerialize(){

	tunerVector<unsigned char> payload;
	return payload;
}

short clCMATStationInfoStatus::u16GetSize(){

	return 0;
}

void clCMATStationInfoStatus::vConstruct(tunerVector<unsigned char> bitStream){

	short pos = 0;
	unsigned char LSB = 0;
	unsigned char MSB = 0;

	tunerString oRdsStationname((const char *)&(bitStream[pos]), RDSSTATIONNAMELENGTH);
	RdsStationname = oRdsStationname;
	pos =(short)(pos + RDSSTATIONNAMELENGTH);

	RdsStationnameInfo.enType = static_cast<clCMEnum_RdsStationnameInfo::enRdsStationnameInfo>(bitStream[pos++]);

	Frequency = getInt(bitStream, pos);
	pos =(short)(pos + sizeof(Frequency));

	PTY = bitStream[pos++];

	MSB = bitStream[pos++];
	LSB = bitStream[pos++];
	PI = getWord(LSB, MSB);

	ATStationTpInfo.enType = static_cast<clCMEnum_ATStationTpInfo::enATStationTpInfo>(bitStream[pos++]);

	ATStationTmcInfo.enType = static_cast<clCMEnum_ATStationTmcInfo::enATStationTmcInfo>(bitStream[pos++]);

	Fieldstrength = bitStream[pos++];

	Quality = bitStream[pos++];

	Band.enType = static_cast<clCMEnum_Band::enBand>(bitStream[pos++]);

	MSB = bitStream[pos++];
	LSB = bitStream[pos++];
	ActivePresetList = getWord(LSB, MSB);

	ActiveStationList = bitStream[pos++];

	MSB = bitStream[pos++];
	LSB = bitStream[pos++];
	PresetAutocompare = getWord(LSB, MSB);

	MSB = bitStream[pos++];
	LSB = bitStream[pos++];
	StationListAutocompare = getWord(LSB, MSB);

	ATStationInfoBits = bitStream[pos++];

	ConstructHDParams(bitStream, pos);
	ConstructDRMParams(bitStream, pos);
	Constructrfu_bytes(bitStream, pos);
}

void clCMATStationInfoStatus::ConstructHDParams(tunerVector<unsigned char> bitStream, short &pos)
{
	HDStationInfoBits = bitStream[pos++];

	HDStationId = getInt(bitStream, pos);
	pos =(short)(pos + sizeof(HDStationId));

	tunerString oHDCallSign((const char *)&(bitStream[pos]), HDCALLSIGNLENGTH);
	HDCallSign = oHDCallSign;
	pos =(short)(pos + HDCALLSIGNLENGTH);

	HDCallsignTextEncoding = bitStream[pos++];

	HDStationGenre = bitStream[pos++];

	HDNumberOfAudioServices = bitStream[pos++];

	HDQuality = bitStream[pos++];

	HDActiveAudioProgram.enType = static_cast<clCMEnum_HDActiveAudioProgram::enHDActiveAudioProgram>(bitStream[pos++]);
}

void clCMATStationInfoStatus::ConstructDRMParams(tunerVector<unsigned char> bitStream, short &pos)
{
	DRMStationInfoBits = bitStream[pos++];

	DRMServiceId = getInt(bitStream, pos);
	pos =(short)(pos + sizeof(DRMServiceId));

	tunerVector<unsigned char>::iterator it;
	it = bitStream.begin() + pos;
	DRMServiceLabel.assign(it, it + DRMSERVICELABEL_SIZE);
	pos =(short)(pos + DRMSERVICELABEL_SIZE);

	DRMPTY = bitStream[pos++];

	unsigned char MSB = bitStream[pos++];
	unsigned char LSB = bitStream[pos++];
	DRMAnnoSupport = getWord(LSB, MSB);

	DRMNumberOfAudioServices = bitStream[pos++];

	DRMQuality = bitStream[pos++];

	DRMServiceShortId.enType = static_cast<clCMEnum_DRMServiceShortId::enDRMServiceShortId>(bitStream[pos++]);
}

void clCMATStationInfoStatus::Constructrfu_bytes(tunerVector<unsigned char> bitStream, short &pos)
{
	rfu_byte_0 = bitStream[pos++];
	rfu_byte_1 = bitStream[pos++];
	rfu_byte_2 = bitStream[pos++];
	rfu_byte_3 = bitStream[pos++];
	rfu_byte_4 = bitStream[pos++];
	rfu_byte_5 = bitStream[pos++];
	rfu_byte_6 = bitStream[pos++];
	rfu_byte_7 = bitStream[pos++];
	rfu_byte_8 = bitStream[pos++];
	rfu_byte_9 = bitStream[pos++];
	rfu_byte_10 = bitStream[pos++];
	rfu_byte_11 = bitStream[pos++];
}

void clCMATStationInfoStatus::setRdsStationname(tunerString newRdsStationname){

	unsigned short stringSize = (unsigned short)newRdsStationname.size();
	if (newRdsStationname.size() > RDSSTATIONNAMELENGTH)
	{
		stringSize = RDSSTATIONNAMELENGTH;
	}
	tunerString oString(newRdsStationname.c_str(), stringSize);
	RdsStationname = oString;
}

void clCMATStationInfoStatus::setRdsStationnameInfo(clCMEnum_RdsStationnameInfo::enRdsStationnameInfo newRdsStationnameInfo){

	RdsStationnameInfo.enType = newRdsStationnameInfo;
}

void clCMATStationInfoStatus::setFrequency(unsigned int newFrequency){

	Frequency = newFrequency;
}

void clCMATStationInfoStatus::setPTY(unsigned char newPTY){

	PTY = newPTY;
}

void clCMATStationInfoStatus::setPI(unsigned short newPI){

	PI = newPI;
}

void clCMATStationInfoStatus::setATStationTpInfo(clCMEnum_ATStationTpInfo::enATStationTpInfo newATStationTpInfo){

	ATStationTpInfo.enType = newATStationTpInfo;
}

void clCMATStationInfoStatus::setATStationTmcInfo(clCMEnum_ATStationTmcInfo::enATStationTmcInfo newATStationTmcInfo){

	ATStationTmcInfo.enType = newATStationTmcInfo;
}

void clCMATStationInfoStatus::setFieldstrength(unsigned char newFieldstrength){

	Fieldstrength = newFieldstrength;
}

void clCMATStationInfoStatus::setQuality(unsigned char newQuality){

	Quality = newQuality;
}

void clCMATStationInfoStatus::setBand(clCMEnum_Band::enBand newBand){

	Band.enType = newBand;
}

void clCMATStationInfoStatus::setActivePresetList(unsigned short newActivePresetList){

	ActivePresetList = newActivePresetList;
}

void clCMATStationInfoStatus::setActiveStationList(unsigned char newActiveStationList){

	ActiveStationList = newActiveStationList;
}

void clCMATStationInfoStatus::setPresetAutocompare(unsigned short newPresetAutocompare){

	PresetAutocompare = newPresetAutocompare;
}

void clCMATStationInfoStatus::setStationListAutocompare(unsigned short newStationListAutocompare){

	StationListAutocompare = newStationListAutocompare;
}

void clCMATStationInfoStatus::setATStationInfoBits(unsigned char newATStationInfoBits){

	ATStationInfoBits = newATStationInfoBits;
}

void clCMATStationInfoStatus::setHDStationInfoBits(unsigned char newHDStationInfoBits){

	HDStationInfoBits = newHDStationInfoBits;
}

void clCMATStationInfoStatus::setHDStationId(unsigned long newHDStationId){

	HDStationId = (unsigned int)newHDStationId;
}

void clCMATStationInfoStatus::setHDCallSign(tunerString newHDCallSign){

	unsigned short stringSize = (unsigned short)newHDCallSign.size();
	if (newHDCallSign.size() > HDCALLSIGNLENGTH)
	{
		stringSize = HDCALLSIGNLENGTH;
	}
	tunerString oString(newHDCallSign.c_str(), stringSize);
	HDCallSign = oString;
}

void clCMATStationInfoStatus::setHDCallsignTextEncoding(unsigned char newHDCallsignTextEncoding){

	HDCallsignTextEncoding = newHDCallsignTextEncoding;
}

void clCMATStationInfoStatus::setHDStationGenre(unsigned char newHDStationGenre){

	HDStationGenre = newHDStationGenre;
}

void clCMATStationInfoStatus::setHDNumberOfAudioServices(unsigned char newHDNumberOfAudioServices){

	HDNumberOfAudioServices = newHDNumberOfAudioServices;
}

void clCMATStationInfoStatus::setHDQuality(unsigned char newHDQuality){

	HDQuality = newHDQuality;
}

void clCMATStationInfoStatus::setHDActiveAudioProgram(clCMEnum_HDActiveAudioProgram::enHDActiveAudioProgram newHDActiveAudioProgram){

	HDActiveAudioProgram.enType = newHDActiveAudioProgram;
}

void clCMATStationInfoStatus::setDRMStationInfoBits(unsigned char newDRMStationInfoBits){

	DRMStationInfoBits = newDRMStationInfoBits;
}

void clCMATStationInfoStatus::setDRMServiceId(unsigned long newDRMServiceId){

	DRMServiceId = (unsigned int)newDRMServiceId;
}

void clCMATStationInfoStatus::setDRMServiceLabel(tunerVector<unsigned char> newDRMServiceLabel){

	DRMServiceLabel = newDRMServiceLabel;
}

void clCMATStationInfoStatus::setDRMPTY(unsigned char newDRMPTY){

	DRMPTY = newDRMPTY;
}

void clCMATStationInfoStatus::setDRMAnnoSupport(unsigned short newDRMAnnoSupport){

	DRMAnnoSupport = newDRMAnnoSupport;
}

void clCMATStationInfoStatus::setDRMNumberOfAudioServices(unsigned char newDRMNumberOfAudioServices){

	DRMNumberOfAudioServices = newDRMNumberOfAudioServices;
}

void clCMATStationInfoStatus::setDRMQuality(unsigned char newDRMQuality){

	DRMQuality = newDRMQuality;
}

void clCMATStationInfoStatus::setDRMServiceShortId(clCMEnum_DRMServiceShortId::enDRMServiceShortId newDRMServiceShortId){

	DRMServiceShortId.enType = newDRMServiceShortId;
}

void clCMATStationInfoStatus::setrfu_byte_0(unsigned char newrfu_byte){

	rfu_byte_0 = newrfu_byte;
}

void clCMATStationInfoStatus::setrfu_byte_1(unsigned char newrfu_byte){

	rfu_byte_1 = newrfu_byte;
}

void clCMATStationInfoStatus::setrfu_byte_2(unsigned char newrfu_byte){

	rfu_byte_2 = newrfu_byte;
}

void clCMATStationInfoStatus::setrfu_byte_3(unsigned char newrfu_byte){

	rfu_byte_3 = newrfu_byte;
}

void clCMATStationInfoStatus::setrfu_byte_4(unsigned char newrfu_byte){

	rfu_byte_4 = newrfu_byte;
}

void clCMATStationInfoStatus::setrfu_byte_5(unsigned char newrfu_byte){

	rfu_byte_5 = newrfu_byte;
}

void clCMATStationInfoStatus::setrfu_byte_6(unsigned char newrfu_byte){

	rfu_byte_6 = newrfu_byte;
}

void clCMATStationInfoStatus::setrfu_byte_7(unsigned char newrfu_byte){

	rfu_byte_7 = newrfu_byte;
}

void clCMATStationInfoStatus::setrfu_byte_8(unsigned char newrfu_byte){

	rfu_byte_8 = newrfu_byte;
}

void clCMATStationInfoStatus::setrfu_byte_9(unsigned char newrfu_byte){

	rfu_byte_9 = newrfu_byte;
}

void clCMATStationInfoStatus::setrfu_byte_10(unsigned char newrfu_byte){

	rfu_byte_10 = newrfu_byte;
}

void clCMATStationInfoStatus::setrfu_byte_11(unsigned char newrfu_byte){

	rfu_byte_11 = newrfu_byte;
}

const char * clCMATStationInfoStatus::getRdsStationname(){

	return RdsStationname.c_str();
}

clCMEnum_RdsStationnameInfo::enRdsStationnameInfo clCMATStationInfoStatus::getRdsStationnameInfo(){

	return RdsStationnameInfo.enType;
}

unsigned int clCMATStationInfoStatus::getFrequency(){

	return Frequency;
}

unsigned char clCMATStationInfoStatus::getPTY(){

	return PTY;
}
unsigned short clCMATStationInfoStatus::getPI(){

	return PI;
}

clCMEnum_ATStationTpInfo::enATStationTpInfo clCMATStationInfoStatus::getATStationTpInfo(){

	return ATStationTpInfo.enType;
}

clCMEnum_ATStationTmcInfo::enATStationTmcInfo clCMATStationInfoStatus::getATStationTmcInfo(){

	return ATStationTmcInfo.enType;
}

unsigned char clCMATStationInfoStatus::getFieldstrength(){

	return Fieldstrength;
}

unsigned char clCMATStationInfoStatus::getQuality(){

	return Quality;
}

clCMEnum_Band::enBand clCMATStationInfoStatus::getBand(){

	return Band.enType;
}

unsigned short clCMATStationInfoStatus::getActivePresetList(){

	return ActivePresetList;
}

unsigned char clCMATStationInfoStatus::getActiveStationList(){

	return ActiveStationList;
}

unsigned short clCMATStationInfoStatus::getPresetAutocompare(){

	return PresetAutocompare;
}

unsigned short clCMATStationInfoStatus::getStationListAutocompare(){

	return StationListAutocompare;
}

unsigned char clCMATStationInfoStatus::getATStationInfoBits(){

	return ATStationInfoBits;
}

unsigned char clCMATStationInfoStatus::getHDStationInfoBits(){

	return HDStationInfoBits;
}

unsigned long clCMATStationInfoStatus::getHDStationId(){

	return HDStationId;
}

const char * clCMATStationInfoStatus::getHDCallSign(){

	return HDCallSign.c_str();
}

unsigned char clCMATStationInfoStatus::getHDCallsignTextEncoding(){

	return HDCallsignTextEncoding;
}

unsigned char clCMATStationInfoStatus::getHDStationGenre(){

	return HDStationGenre;
}

unsigned char clCMATStationInfoStatus::getHDNumberOfAudioServices(){

	return HDNumberOfAudioServices;
}

unsigned char clCMATStationInfoStatus::getHDQuality(){

	return HDQuality;
}

clCMEnum_HDActiveAudioProgram::enHDActiveAudioProgram clCMATStationInfoStatus::getHDActiveAudioProgram(){

	return HDActiveAudioProgram.enType;
}

unsigned char clCMATStationInfoStatus::getDRMStationInfoBits(){

	return DRMStationInfoBits;
}

unsigned long clCMATStationInfoStatus::getDRMServiceId(){

	return DRMServiceId;
}

tunerVector<unsigned char> clCMATStationInfoStatus::getDRMServiceLabel(){

	return DRMServiceLabel;
}

unsigned char clCMATStationInfoStatus::getDRMPTY(){

	return DRMPTY;
}

unsigned short clCMATStationInfoStatus::getDRMAnnoSupport(){

	return DRMAnnoSupport;
}

unsigned char clCMATStationInfoStatus::getDRMNumberOfAudioServices(){

	return DRMNumberOfAudioServices;
}

unsigned char clCMATStationInfoStatus::getDRMQuality(){

	return DRMQuality;
}

clCMEnum_DRMServiceShortId::enDRMServiceShortId clCMATStationInfoStatus::getDRMServiceShortId(){

	return DRMServiceShortId.enType;
}

unsigned char clCMATStationInfoStatus::getrfu_byte_0(){

	return rfu_byte_0;
}

unsigned char clCMATStationInfoStatus::getrfu_byte_1(){

	return rfu_byte_1;
}

unsigned char clCMATStationInfoStatus::getrfu_byte_2(){

	return rfu_byte_2;
}

unsigned char clCMATStationInfoStatus::getrfu_byte_3(){

	return rfu_byte_3;
}

unsigned char clCMATStationInfoStatus::getrfu_byte_4(){

	return rfu_byte_4;
}

unsigned char clCMATStationInfoStatus::getrfu_byte_5(){

	return rfu_byte_5;
}

unsigned char clCMATStationInfoStatus::getrfu_byte_6(){

	return rfu_byte_6;
}

unsigned char clCMATStationInfoStatus::getrfu_byte_7(){

	return rfu_byte_7;
}

unsigned char clCMATStationInfoStatus::getrfu_byte_8(){

	return rfu_byte_8;
}

unsigned char clCMATStationInfoStatus::getrfu_byte_9(){

	return rfu_byte_9;
}

unsigned char clCMATStationInfoStatus::getrfu_byte_10(){

	return rfu_byte_10;
}

unsigned char clCMATStationInfoStatus::getrfu_byte_11(){

	return rfu_byte_11;
}
