///////////////////////////////////////////////////////////
//  clCMATPresetList_XX.h
//  Implementation of the Class clCMATPresetList_XX
//  Created on:      14-Jan-2015 5:39:25 PM
//  Original author: pmn3kor
///////////////////////////////////////////////////////////

#ifndef clCMATPresetList_XX_h
#define clCMATPresetList_XX_h

#include "clADRMsgPayload.h"
#include "datatypes/tVector.h"
#include "datatypes/tString.h"
#include "types/clCMADRBaseTypes.h"

class clCMATPresetList_XX : public clADRMsgPayload
{

public:
	clCMATPresetList_XX(unsigned short presetListSize);
	virtual ~clCMATPresetList_XX();
	clCMATPresetList_XX();
	virtual tunerVector<unsigned char> oSerialize();
	virtual short u16GetSize();
	virtual void vConstruct(tunerVector<unsigned char> bitStream);

	clCMATPresetList_Data& getData(unsigned short index)
	{
		if(index != 0)
		{
			return Data[--index];
		}
		return Data[index]; // not to be used add trace error...
	}

	clCMADRBaseType_Pos Pos;
	bool bIsStaticSize();

private:

   tunerVector<clCMATPresetList_Data> Data;

   void vConstructData(tunerVector<unsigned char>& bitStream, unsigned short& position);
   bool bIsAllValuesSent() ;
   void vConstructAllValues(tunerVector<unsigned char>& bitStream, unsigned short& position);
   void vConstructSelectedValues(tunerVector<unsigned char>& bitStream, unsigned short& position);
   bool bIsAllElementsSent();
   void vConstructRow(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short& position) ;
   void vConstructColumn(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position) ;
   void vConstructPresetSelection(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position) ;
   void vConstructFrequency(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position);
   void vConstructSenderName(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position);
   void vConstructPI(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position);
   void vConstructStationNameInfo(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short & position);
   void vConstructTPTMCInfo(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short & position);
   void vConstructPTY(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short & position);
   void vConstructLevelCompensation(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position);
   void vConstructDigitalModulation(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position);
   void vConstructHDStationID(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position);
   void vConstructStationNameLength(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position);
   void vConstructHDCallSign(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position);
   void vConstructHDTextEncoding(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position);
   void vConstructHDStationGenre(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position);
   void vConstructHDProgramNumber(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position);

   void vSerializeData(tunerVector<unsigned char>& payload);
   void vSerializeAllValues(tunerVector<unsigned char>& payload);
   void vSerializeSelectedValues(tunerVector<unsigned char>& payload);
   void vSerializeRow(tunerVector<unsigned char>& payload, unsigned short index, unsigned char& ListStartIndex);
   void vSerializeColumn(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column, unsigned char& ListStartIndex);
   void vSerializePresetSelection(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
   void vSerializeFrequency(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
   void vSerializeSenderName(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
   void vSerializePI(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
   void vSerializeStationNameInfo(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
   void vSerializeTPTMCInfo(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
   void vSerializePTY(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
   void vSerializeLevelCompensation(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
   void vSerializeDigitalModulation(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
   void vSerializeHDStationID(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
   void vSerializeStationNameLength(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
   void vSerializeHDCallSign(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
   void vSerializeHDTextEncoding(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
   void vSerializeHDStationGenre(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
   void vSerializeHDProgramNumber(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);

   bool bIsAllValuesRequested();
   bool bIsAllElementsRequested();

};
#endif // !defined(clCMATPresetList_XX_h)
