///////////////////////////////////////////////////////////
//  clCMATPresetListConfigStatus.h
//  Implementation of the Class clCMATPresetListConfigStatus
//  Created on:      21-Apr-2015 2:17:45 PM
///////////////////////////////////////////////////////////

#if !defined(EA_6EE57460_ED68_4884_9E95_3653ED31CB7A__INCLUDED_)
#define EA_6EE57460_ED68_4884_9E95_3653ED31CB7A__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMEnumTypes.h"

class clCMATPresetListConfigStatus : public clADRMsgPayload
{

public:
	/**
	 * Unsigned word
	 */
	unsigned short FktId;
	/**
	 * Enumeration 0..18
	 */
	clCMEnum_Band Band;
	/**
	 * Unsigned word 0 ..0xff
	 */
	unsigned char NumberOfPresets;

	clCMATPresetListConfigStatus();
	virtual ~clCMATPresetListConfigStatus();
	/**
	 * constructs the data stream
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * Serialize data stream
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the data stream
	 */
	short u16GetSize();
	/**
	 * read ATPresetListConfigStatus parameters
	 */
	clCMEnum_Band::enBand getBand();
	unsigned short getFktId();
	unsigned char getNumberOfPresets();
	/**
	 * set ATPresetListConfigStatus parameters
	 */
	void setBand(clCMEnum_Band::enBand newBand);
	void setFktId(unsigned short newFktId);
	void setNumberOfPresets(unsigned char newNumberOfPresets);
};

#endif // !defined(EA_6EE57460_ED68_4884_9E95_3653ED31CB7A__INCLUDED_)
