///////////////////////////////////////////////////////////
//  clCMATLsmSetupSet.cpp
//  Implementation of the Class clCMATLsmSetupSet
//  Created on:      14-Apr-2015 6:22:28 PM
///////////////////////////////////////////////////////////

#include "clCMATLsmSetupSet.h"

clCMATLsmSetupSet::clCMATLsmSetupSet() :
Frequency(0),
PI(0),
HDStationId_DRMServiceId(0),
RFU_byte_0(0),
RFU_byte_1(0),
RFU_byte_2(0),
RFU_byte_3(0) {

}


clCMATLsmSetupSet::~clCMATLsmSetupSet(){

}

tunerVector<unsigned char> clCMATLsmSetupSet::oSerialize(){

	tunerVector<unsigned char> payload;

	payload.push_back(static_cast<unsigned char>(Band.enType));
	vAddInt(payload, Frequency);
	vAddShort(payload, PI);
	vAddInt(payload, HDStationId_DRMServiceId);
	payload.push_back(static_cast<unsigned char>(ModulationType.enType));
	payload.push_back(RFU_byte_0);
	payload.push_back(RFU_byte_1);
	payload.push_back(RFU_byte_2);
	payload.push_back(RFU_byte_3);

	return payload;
}

short clCMATLsmSetupSet::u16GetSize(){

	short size = 0;
	size = (short)(Band.getSize() + sizeof(Frequency) + sizeof(PI)
			+ sizeof(HDStationId_DRMServiceId) + ModulationType.getSize() + sizeof(RFU_byte_0)
			+ sizeof(RFU_byte_1) + sizeof(RFU_byte_2) + sizeof(RFU_byte_3));

	return size;
}

void clCMATLsmSetupSet::vConstruct(tunerVector<unsigned char> /*bitStream*/){

}

void clCMATLsmSetupSet::setBand(clCMEnum_Band::enBand newBand){

	Band.enType = newBand;
}

void clCMATLsmSetupSet::setFrequency(unsigned int newFrequency){

	Frequency = newFrequency;
}

void clCMATLsmSetupSet::setPI(unsigned short newPI){

	PI = newPI;
}

void clCMATLsmSetupSet::setHDStationId_DRMServiceId(unsigned int newHDStationId_DRMServiceId){

	HDStationId_DRMServiceId = newHDStationId_DRMServiceId;
}

void clCMATLsmSetupSet::setModulationType(clCMEnum_ModulationType::enModulationType newModulationType){

	ModulationType.enType = newModulationType;
}

void clCMATLsmSetupSet::setRFU_byte_0(unsigned char newRFU_byte_0){

	RFU_byte_0 = newRFU_byte_0;
}

void clCMATLsmSetupSet::setRFU_byte_1(unsigned char newRFU_byte_1){

	RFU_byte_1 = newRFU_byte_1;
}

void clCMATLsmSetupSet::setRFU_byte_2(unsigned char newRFU_byte_2){

	RFU_byte_2 = newRFU_byte_2;
}

void clCMATLsmSetupSet::setRFU_byte_3(unsigned char newRFU_byte_3){

	RFU_byte_3 = newRFU_byte_3;
}
