///////////////////////////////////////////////////////////
//  clCMATHDStationMessageStatus.h
//  Implementation of the Class clCMATHDStationMessageStatus
//  Created on:      12-May-2015 5:13:42 PM
///////////////////////////////////////////////////////////

#if !defined(EA_2DD3F890_B28B_47aa_BFA9_C4B4F9CFE8AE__INCLUDED_)
#define EA_2DD3F890_B28B_47aa_BFA9_C4B4F9CFE8AE__INCLUDED_

#include "clADRMsgPayload.h"
#include "datatypes/tString.h"

class clCMATHDStationMessageStatus : public clADRMsgPayload
{

public:
	/**
	 * Unsigned long word 0..0xffffffff
	 */
	unsigned int HDStationId;
	/**
	 * Unsigned byte 0 .. 0xff
	 */
	unsigned char Reserved_StatusByte0;
	unsigned char Reserved_StatusByte1;
	unsigned char Reserved_StatusByte2;
	unsigned char Reserved_StatusByte3;
	unsigned char Reserved_StatusByte4;
	unsigned char Reserved_StatusByte5;
	unsigned char Reserved_StatusByte6;
	unsigned char Reserved_StatusByte7;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char HDTextEncoding;
	/**
	 * String 190 bytes size
	 */
	tunerString HDStationMessage;

	clCMATHDStationMessageStatus();
	virtual ~clCMATHDStationMessageStatus();
	/**
	 * serialize the data stream
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the data stream
	 */
	short u16GetSize();
	/**
	 * construct the data stream
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * set HDStationMessageStatus parameters
	 */
	void setHDStationId(unsigned int newHDStationId);
	void setReserved_StatusByte0(unsigned char newReserved_StatusByte0);
	void setReserved_StatusByte1(unsigned char newReserved_StatusByte1);
	void setReserved_StatusByte2(unsigned char newReserved_StatusByte2);
	void setReserved_StatusByte3(unsigned char newReserved_StatusByte3);
	void setReserved_StatusByte4(unsigned char newReserved_StatusByte4);
	void setReserved_StatusByte5(unsigned char newReserved_StatusByte5);
	void setReserved_StatusByte6(unsigned char newReserved_StatusByte6);
	void setReserved_StatusByte7(unsigned char newReserved_StatusByte7);
	void setHDTextEncoding(unsigned char newHDTextEncoding);
	void setHDStationMessage(tunerString newHDStationMessage);
	/**
	 * read HDStationMessageStatus parameters
	 */
	unsigned int getHDStationId();
	unsigned char getReserved_StatusByte0();
	unsigned char getReserved_StatusByte1();
	unsigned char getReserved_StatusByte2();
	unsigned char getReserved_StatusByte3();
	unsigned char getReserved_StatusByte4();
	unsigned char getReserved_StatusByte5();
	unsigned char getReserved_StatusByte6();
	unsigned char getReserved_StatusByte7();
	unsigned char getHDTextEncoding();
	const char* getHDStationMessage();

};
#endif // !defined(EA_2DD3F890_B28B_47aa_BFA9_C4B4F9CFE8AE__INCLUDED_)
