///////////////////////////////////////////////////////////
//  clCMATHDStationMessageStatus.cpp
//  Implementation of the Class clCMATHDStationMessageStatus
//  Created on:      12-May-2015 5:13:42 PM
///////////////////////////////////////////////////////////

#include "clCMATHDStationMessageStatus.h"

#define HDSTATIONMESSAGE_LEN 190

clCMATHDStationMessageStatus::clCMATHDStationMessageStatus(): HDStationId(0),
Reserved_StatusByte0(0),
Reserved_StatusByte1(0),
Reserved_StatusByte2(0),
Reserved_StatusByte3(0),
Reserved_StatusByte4(0),
Reserved_StatusByte5(0),
Reserved_StatusByte6(0),
Reserved_StatusByte7(0),
HDTextEncoding(0){

}

clCMATHDStationMessageStatus::~clCMATHDStationMessageStatus(){

}

tunerVector<unsigned char> clCMATHDStationMessageStatus::oSerialize(){

	tunerVector<unsigned char> payload;
	return payload;
}

short clCMATHDStationMessageStatus::u16GetSize(){

	return 0;
}

void clCMATHDStationMessageStatus::vConstruct(tunerVector<unsigned char> bitStream){

	unsigned short position = 0;

	HDStationId = getInt(bitStream, position);
	position = (unsigned short)(position + sizeof(HDStationId));

	Reserved_StatusByte0 = bitStream[position++];
	Reserved_StatusByte1 = bitStream[position++];
	Reserved_StatusByte2 = bitStream[position++];
	Reserved_StatusByte3 = bitStream[position++];
	Reserved_StatusByte4 = bitStream[position++];
	Reserved_StatusByte5 = bitStream[position++];
	Reserved_StatusByte6 = bitStream[position++];
	Reserved_StatusByte7 = bitStream[position++];

	HDTextEncoding = bitStream[position++];
	if( bitStream.size() >= (unsigned short)(position + HDSTATIONMESSAGE_LEN))
	{
		tunerString oString((const char*)&(bitStream[position]), HDSTATIONMESSAGE_LEN);
		HDStationMessage = oString;
	}
	position = (unsigned short)(position + HDSTATIONMESSAGE_LEN);
}

void clCMATHDStationMessageStatus::setHDStationId(unsigned int newHDStationId){

	HDStationId = newHDStationId;
}

void clCMATHDStationMessageStatus::setReserved_StatusByte0(unsigned char newReserved_StatusByte0){

	Reserved_StatusByte0 = newReserved_StatusByte0;
}

void clCMATHDStationMessageStatus::setReserved_StatusByte1(unsigned char newReserved_StatusByte1){

	Reserved_StatusByte1 = newReserved_StatusByte1;
}

void clCMATHDStationMessageStatus::setReserved_StatusByte2(unsigned char newReserved_StatusByte2){

	Reserved_StatusByte2 = newReserved_StatusByte2;
}

void clCMATHDStationMessageStatus::setReserved_StatusByte3(unsigned char newReserved_StatusByte3){

	Reserved_StatusByte3 = newReserved_StatusByte3;
}

void clCMATHDStationMessageStatus::setReserved_StatusByte4(unsigned char newReserved_StatusByte4){

	Reserved_StatusByte4 = newReserved_StatusByte4;
}

void clCMATHDStationMessageStatus::setReserved_StatusByte5(unsigned char newReserved_StatusByte5){

	Reserved_StatusByte5 = newReserved_StatusByte5;
}

void clCMATHDStationMessageStatus::setReserved_StatusByte6(unsigned char newReserved_StatusByte6){

	Reserved_StatusByte6 = newReserved_StatusByte6;
}

void clCMATHDStationMessageStatus::setReserved_StatusByte7(unsigned char newReserved_StatusByte7){

	Reserved_StatusByte7 = newReserved_StatusByte7;
}

void clCMATHDStationMessageStatus::setHDTextEncoding(unsigned char newHDTextEncoding){

	HDTextEncoding = newHDTextEncoding;
}

void clCMATHDStationMessageStatus::setHDStationMessage(tunerString newHDStationMessage){

	unsigned short stringSize = (unsigned short)newHDStationMessage.size();
	if(newHDStationMessage.size() > HDSTATIONMESSAGE_LEN)
	{
		stringSize = HDSTATIONMESSAGE_LEN;
	}
	tunerString oString(newHDStationMessage.c_str(), stringSize);
	HDStationMessage = oString;
}

unsigned int clCMATHDStationMessageStatus::getHDStationId(){

	return HDStationId;
}

unsigned char clCMATHDStationMessageStatus::getReserved_StatusByte0(){

	return Reserved_StatusByte0;
}

unsigned char clCMATHDStationMessageStatus::getReserved_StatusByte1(){

	return Reserved_StatusByte1;
}

unsigned char clCMATHDStationMessageStatus::getReserved_StatusByte2(){

	return Reserved_StatusByte2;
}

unsigned char clCMATHDStationMessageStatus::getReserved_StatusByte3(){

	return Reserved_StatusByte3;
}

unsigned char clCMATHDStationMessageStatus::getReserved_StatusByte4(){

	return Reserved_StatusByte4;
}

unsigned char clCMATHDStationMessageStatus::getReserved_StatusByte5(){

	return Reserved_StatusByte5;
}

unsigned char clCMATHDStationMessageStatus::getReserved_StatusByte6(){

	return Reserved_StatusByte6;
}

unsigned char clCMATHDStationMessageStatus::getReserved_StatusByte7(){

	return Reserved_StatusByte7;
}

unsigned char clCMATHDStationMessageStatus::getHDTextEncoding(){

	return HDTextEncoding;
}

const char* clCMATHDStationMessageStatus::getHDStationMessage(){

	return HDStationMessage.c_str();
}
