///////////////////////////////////////////////////////////
//  clCMATHDStationMessageGet.cpp
//  Implementation of the Class clCMATHDStationMessageGet
//  Created on:      12-May-2015 4:24:52 PM
///////////////////////////////////////////////////////////

#include "clCMATHDStationMessageGet.h"

clCMATHDStationMessageGet::clCMATHDStationMessageGet() : HDStationId(0),
Reserved_GetByte0(0),
Reserved_GetByte1(0),
Reserved_GetByte2(0),
Reserved_GetByte3(0){

}

clCMATHDStationMessageGet::~clCMATHDStationMessageGet(){

}

tunerVector<unsigned char> clCMATHDStationMessageGet::oSerialize(){

	tunerVector<unsigned char> payload;

	vAddInt(payload, HDStationId);
	payload.push_back(Reserved_GetByte0);
	payload.push_back(Reserved_GetByte1);
	payload.push_back(Reserved_GetByte2);
	payload.push_back(Reserved_GetByte3);

	return payload;
}

short clCMATHDStationMessageGet::u16GetSize(){

	return sizeof(HDStationId) + sizeof(Reserved_GetByte0) + sizeof(Reserved_GetByte1) +
			sizeof(Reserved_GetByte2) + sizeof(Reserved_GetByte3) ;
}

void clCMATHDStationMessageGet::vConstruct(tunerVector<unsigned char> /*bitStream*/){

}

void clCMATHDStationMessageGet::setHDStationId(unsigned int newHDStationId){

	HDStationId = newHDStationId;
}

void clCMATHDStationMessageGet::setReserved_GetByte0(unsigned char newReserved_GetByte0){

	Reserved_GetByte0 = newReserved_GetByte0;
}

void clCMATHDStationMessageGet::setReserved_GetByte1(unsigned char newReserved_GetByte1){

	Reserved_GetByte1 = newReserved_GetByte1;
}

void clCMATHDStationMessageGet::setReserved_GetByte2(unsigned char newReserved_GetByte2){

	Reserved_GetByte2 = newReserved_GetByte2;
}

void clCMATHDStationMessageGet::setReserved_GetByte3(unsigned char newReserved_GetByte3){

	Reserved_GetByte3 = newReserved_GetByte3;
}
