///////////////////////////////////////////////////////////
//  clCMATHDPSDDataFrameStatus.h
//  Implementation of the Class clCMATHDPSDDataFrameStatus
//  Created on:      24-Feb-2015 2:17:29 PM
///////////////////////////////////////////////////////////

#if !defined(EA_707EF04E_942F_4c8c_8D70_852D23B0B02D__INCLUDED_)
#define EA_707EF04E_942F_4c8c_8D70_852D23B0B02D__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMEnumTypes.h"
#include "datatypes/tString.h"
#include "types/clCMADRBaseTypes.h"

#define PSDDATAFRAME_RESERVEDBYTES  8

class clCMATHDPSDDataFrameStatus : public clADRMsgPayload
{

public:
	/**
	 * Constructor
	 */
	clCMATHDPSDDataFrameStatus();
	/**
	 * Destructor
	 */
	virtual ~clCMATHDPSDDataFrameStatus();
	/**
	 * Unsigned long word 0..0xffffffff
	 */
	unsigned long HDStationId;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char ReservedByte_x[PSDDATAFRAME_RESERVEDBYTES];
	/**
	 * Unsigned word
	 */
	unsigned short NumberOfPSDDataFrameBytes;
	/**
	 * Stream of PSDDataFrame
	 */
	clCMADRBaseType_PSDDataFrameBytes PSDDataFrameBytes;
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	void vConstructPSDDataFrameBytes(tunerVector<unsigned char> bitStream, unsigned short pos);
	clCMADRBaseType_PSDDataFrame oGetPSDFrame(tunerVector<unsigned char> bitStream, unsigned short &pos);
	/**
	 * Set HD station Id
	 */
	void setHDStationId(unsigned long newHDStationId);
	/**
	 * Set Number of PSD data frame bytes
	 */
	void setNumberOfPSDDataFrameBytes(unsigned char newNumberOfPSDDataFrameBytes);
	/**
	 * Set PSD data frame bytes
	 */
	void setPSDDataFrameBytes(clCMADRBaseType_PSDDataFrameBytes newPSDDataFrameBytes);
	/**
	 * Read HD station Id
	 */
	unsigned long getHDStationId();
	/**
	 * Read Number of PSD data frame bytes
	 */
	unsigned char getNumberOfPSDDataFrameBytes();
	/**
	 * Read PSD data frame bytes
	 */
	clCMADRBaseType_PSDDataFrameBytes getPSDDataFrameBytes();

};

#endif // !defined(EA_707EF04E_942F_4c8c_8D70_852D23B0B02D__INCLUDED_)
