///////////////////////////////////////////////////////////
//  clCMATHDPSDDataFrameStatus.cpp
//  Implementation of the Class clCMATHDPSDDataFrameStatus
//  Created on:      24-Feb-2015 2:17:29 PM
///////////////////////////////////////////////////////////

#include "clCMATHDPSDDataFrameStatus.h"
#define PSDDATAFRAMESIZE 5

clCMATHDPSDDataFrameStatus::clCMATHDPSDDataFrameStatus() : HDStationId(0),
NumberOfPSDDataFrameBytes(0) {

	for(int ReservedByteNum=0; ReservedByteNum < PSDDATAFRAME_RESERVEDBYTES; ReservedByteNum++){
		ReservedByte_x[ReservedByteNum] = 0;
	}
}

clCMATHDPSDDataFrameStatus::~clCMATHDPSDDataFrameStatus(){

}

tunerVector<unsigned char> clCMATHDPSDDataFrameStatus::oSerialize(){

	tunerVector<unsigned char> PayLoad;
	return  PayLoad;
}

short clCMATHDPSDDataFrameStatus::u16GetSize(){

	return 0;
}

void clCMATHDPSDDataFrameStatus::vConstruct(tunerVector<unsigned char> bitStream){

	unsigned short pos=0;
	unsigned char LSB=0;
	unsigned char MSB=0;
	clCMADRBaseType_PSDDataFrameBytes oPSDDataFrameBytes;

	HDStationId = getInt(bitStream, pos);
	pos = (unsigned short)(pos + 4);
	for(int ReservedbyteNum=0; ReservedbyteNum < PSDDATAFRAME_RESERVEDBYTES; ReservedbyteNum++){
		ReservedByte_x[ReservedbyteNum] = bitStream[pos++];
	}
	MSB = bitStream[pos++];
	LSB = bitStream[pos++];
	NumberOfPSDDataFrameBytes = getWord(LSB, MSB);
	vConstructPSDDataFrameBytes(bitStream, pos);
}

void  clCMATHDPSDDataFrameStatus::vConstructPSDDataFrameBytes(tunerVector<unsigned char> bitStream, unsigned short currentPosition)
{
	unsigned short initialPosition = currentPosition;
	if (NumberOfPSDDataFrameBytes > 0)
	{
		PSDDataFrameBytes.ReservedByte = bitStream[currentPosition++];
	}
	while (NumberOfPSDDataFrameBytes > (currentPosition - initialPosition))
	{
		 unsigned short FieldSubfieldLength =0;
		 if(bitStream.size()> (unsigned short)(currentPosition+PSDDATAFRAMESIZE))
		 {
			 FieldSubfieldLength = (bitStream[currentPosition+PSDDATAFRAMESIZE]);
		 }
		 if(bitStream.size() > (unsigned short)(currentPosition+PSDDATAFRAMESIZE+FieldSubfieldLength))
		 {
			PSDDataFrameBytes.frames.push_back(oGetPSDFrame(bitStream, currentPosition));
		 }
		 else
		 {
			 break;
		 }
	 }
}


clCMADRBaseType_PSDDataFrame clCMATHDPSDDataFrameStatus::oGetPSDFrame(tunerVector<unsigned char> bitStream, unsigned short &currentPosition)
{
	clCMADRBaseType_PSDDataFrame oPSDDataFrame;

	oPSDDataFrame.ProgramNumber = bitStream[currentPosition++];
	oPSDDataFrame.FieldBitMask = bitStream[currentPosition++];
	oPSDDataFrame.Subfield = bitStream[currentPosition++];
	oPSDDataFrame.ReservedByte = bitStream[currentPosition++];
	oPSDDataFrame.Field_SubfieldDataType.enType = static_cast<clCMEnum_PDSFrameSubFieldDataType::enSubFieldDataType>(bitStream[currentPosition++]);
	oPSDDataFrame.Field_SubfieldLength = bitStream[currentPosition++];
	tunerVector<unsigned char> subFieldData(&(bitStream[currentPosition]), (&(bitStream[currentPosition]) + oPSDDataFrame.Field_SubfieldLength));
	oPSDDataFrame.Field_SubfieldData = subFieldData;
	currentPosition = (unsigned short)(currentPosition + oPSDDataFrame.Field_SubfieldLength);

	return oPSDDataFrame;
}

void clCMATHDPSDDataFrameStatus::setHDStationId(unsigned long newHDStationId){

	HDStationId = newHDStationId;
}

void clCMATHDPSDDataFrameStatus::setNumberOfPSDDataFrameBytes(unsigned char newNumberOfPSDDataFrameBytes){

	NumberOfPSDDataFrameBytes = newNumberOfPSDDataFrameBytes;
}

void clCMATHDPSDDataFrameStatus::setPSDDataFrameBytes(clCMADRBaseType_PSDDataFrameBytes newPSDDataFrameBytes){

	PSDDataFrameBytes.ReservedByte = newPSDDataFrameBytes.ReservedByte;
	PSDDataFrameBytes.frames.assign(newPSDDataFrameBytes.frames.begin(), newPSDDataFrameBytes.frames.end());
}

unsigned long clCMATHDPSDDataFrameStatus::getHDStationId(){

		return HDStationId;
}

unsigned char clCMATHDPSDDataFrameStatus::getNumberOfPSDDataFrameBytes(){

	return (unsigned char)NumberOfPSDDataFrameBytes;
}

clCMADRBaseType_PSDDataFrameBytes clCMATHDPSDDataFrameStatus::getPSDDataFrameBytes(){

	clCMADRBaseType_PSDDataFrameBytes otempPSDDataFrameBytes;

	otempPSDDataFrameBytes.ReservedByte = PSDDataFrameBytes.ReservedByte;
	otempPSDDataFrameBytes.frames.assign(PSDDataFrameBytes.frames.begin(), PSDDataFrameBytes.frames.end());

	return otempPSDDataFrameBytes;
}

