///////////////////////////////////////////////////////////
//  clCMATHDPSDDataFrameSet.h
//  Implementation of the Class clCMATHDPSDDataFrameSet
//  Created on:      23-Feb-2015 2:47:12 PM
///////////////////////////////////////////////////////////

#if !defined(EA_BD492079_2CEC_4125_9B40_7EE9C49344AB__INCLUDED_)
#define EA_BD492079_2CEC_4125_9B40_7EE9C49344AB__INCLUDED_

#include "clADRMsgPayload.h"

class clCMATHDPSDDataFrameSet : public clADRMsgPayload
{

public:
	/**
	 * Constructor
	 */
	clCMATHDPSDDataFrameSet();
	/**
	 * Destructor
	 */
	virtual ~clCMATHDPSDDataFrameSet();
	/**
	 * Boolean(1 byte)
	 * Bit# Code Description
	 * Bit 0 False
	 *       True  MPS audio selected
	 * Bit 1 False
	 *       True  SPS 1 audio selected
	 * Bit 2 False
	 *       True  SPS 2 audio selected
	 * Bit 3 False
	 *       True  SPS 3 audio selected
	 * Bit 4 False
	 *       True  SPS 4 audio selected
	 * Bit 5 False
	 *       True  SPS 5 audio selected
	 * Bit 6 False
	 *       True  SPS 6 audio selected
	 * Bit 7 False
	 *       True  SPS 7 audio selected
	 */
	unsigned char ProgramBitMask;
	/**
	 * Boolean(2 byte)
	 * Bit#     Code Description
	 * Bit 0..7 False
	 *          True Reserved
	 * Bit 8 False
	 *        True Title selected
	 * Bit 9 False
	 *       True Artist selected
	 * Bit 10 False
	 *        True Album selected
	 * Bit 11 False
	 *        True Genre selected
	 * Bit 12 False
	 *        True Comment selected
	 * Bit 13 False
	 *        True UFID selected
	 * Bit 14 False
	 *        True Commercial selected
	 * Bit 15 False
	 *        True XHDR selected
	 */
	unsigned short FieldBitMask;
	/**
	 * Boolean(1 byte)
	 * Bit# Code Description
	 * Bit 0 False
	 *       True Language selected
	 * Bit 1 False
	 *       True Short Content Description selected
	 * Bit 2 False
	 *       True The actual text selected
	 * Bit 3..7 False
	 *          True Reserved
	 */
	unsigned char CommentsBitMask;
	/**
	 * Boolean(1 byte)
	 * Bit# Code Description
	 * Bit 0 False
	 *       True Owner identifier selected
	 * Bit 1 False
	 *       True Identifier selected
	 * Bit 2..7 False
	 *          True Reserved
	 */
	unsigned char UFIDBitMask;
	/**
	 * Boolean(1 byte)
	 * Bit# Code Description
	 * Bit 0 False
	 *       True Price String selected
	 * Bit 1 False
	 *       True Valid Until selected
	 * Bit 2 False
	 *       True Contact URL selected
	 * Bit 3 False
	 *       True Received as selected
	 * Bit 4 False
	 *       True Name of Seller selected
	 * Bit 5 False
	 *       True Description selected
	 * Bit 6..7 False
	 *          True Reserved
	 */
	unsigned char CommercialBitMask;
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * Set program bit mask
	 */
	void setProgramBitMask(unsigned char newProgramBitMask);
	/**
	 * Set Field bit mask
	 */
	void setFieldBitMask(unsigned short newFieldBitMask);
	/**
	 * Set comments bit mask
	 */
	void setCommentsBitMask(unsigned char newCommentsBitMask);
	/**
	 * Set UFID bit mask
	 */
	void setUFIDBitMask(unsigned char newUFIDBitMask);
	/**
	 * Set aommercial bit mask
	 */
	void setCommercialBitMask(unsigned char newCommercialBitMask);

};
#endif // !defined(EA_BD492079_2CEC_4125_9B40_7EE9C49344AB__INCLUDED_)
