///////////////////////////////////////////////////////////
//  clCMATHDLongNameGet.h
//  Implementation of the Class clCMATHDLongNameGet
//  Created on:      11-May-2015 10:59:19 AM
///////////////////////////////////////////////////////////

#if !defined(EA_8F4F50F0_0B44_4a7d_BA9F_13CBBE34CAAD__INCLUDED_)
#define EA_8F4F50F0_0B44_4a7d_BA9F_13CBBE34CAAD__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMEnumTypes.h"

class clCMATHDLongNameGet : public clADRMsgPayload
{

public:
	/**
	 * Unsigned long word 0..0xffffffff
	 */
	unsigned int HDStationId;
	/**
	 * Unsigned byte 0 .. 0xff
	 */
	unsigned char Reserved_GetByte0;
	unsigned char Reserved_GetByte1;
	unsigned char Reserved_GetByte2;
	unsigned char Reserved_GetByte3;
	/**
	 * Enumeration 0..7
	 */
	clCMEnum_ATHDAudioProgram HDAudioProgram;

	clCMATHDLongNameGet();
	virtual ~clCMATHDLongNameGet();
	/**
	 * serialize the payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * construct the payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * set HDLongName parameters
	 */
	void setHDStationId(unsigned int newHDStationId);
	void setHDAudioProgram(clCMEnum_ATHDAudioProgram::enATHDAudioProgram newHDAudioProgram);
	void setReserved_GetByte0(unsigned char newReserved_GetByte0);
	void setReserved_GetByte1(unsigned char newReserved_GetByte1);
	void setReserved_GetByte2(unsigned char newReserved_GetByte2);
	void setReserved_GetByte3(unsigned char newReserved_GetByte3);

};
#endif // !defined(EA_8F4F50F0_0B44_4a7d_BA9F_13CBBE34CAAD__INCLUDED_)
